/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.OneShotLatch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LocalFileSystem.class})
public class InitOutputPathTest {
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testErrorOccursUnSynchronized() throws Exception {
        Field lock = FileSystem.class.getDeclaredField("OUTPUT_DIRECTORY_INIT_LOCK");
        lock.setAccessible(true);
        lock.set(null, new NoOpLock());
        try {
            this.runTest(true);
            Assert.fail((String)"should fail with an exception");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            lock.set(null, new ReentrantLock(true));
        }
    }

    @Test
    public void testProperSynchronized() throws Exception {
        this.runTest(false);
    }

    private void runTest(boolean useAwaits) throws Exception {
        File tempFile = this.tempDir.newFile();
        Path path1 = new Path(tempFile.getAbsolutePath(), "1");
        Path path2 = new Path(tempFile.getAbsolutePath(), "2");
        OneShotLatch deleteAwaitLatch1 = new OneShotLatch();
        OneShotLatch deleteAwaitLatch2 = new OneShotLatch();
        OneShotLatch mkdirsAwaitLatch1 = new OneShotLatch();
        OneShotLatch mkdirsAwaitLatch2 = new OneShotLatch();
        OneShotLatch deleteTriggerLatch1 = new OneShotLatch();
        OneShotLatch deletetriggerLatch2 = new OneShotLatch();
        OneShotLatch mkdirsTriggerLatch1 = new OneShotLatch();
        OneShotLatch mkdirsTriggerLatch2 = new OneShotLatch();
        final OneShotLatch createAwaitLatch = new OneShotLatch();
        final OneShotLatch createTriggerLatch = new OneShotLatch();
        PowerMockito.whenNew(LocalDataOutputStream.class).withAnyArguments().thenAnswer((Answer)new Answer<LocalDataOutputStream>(){

            public LocalDataOutputStream answer(InvocationOnMock invocation) throws Throwable {
                createAwaitLatch.trigger();
                createTriggerLatch.await();
                File file = (File)invocation.getArguments()[0];
                return new LocalDataOutputStream(file);
            }
        });
        SyncedFileSystem fs1 = new SyncedFileSystem(deleteAwaitLatch1, mkdirsAwaitLatch1, deleteTriggerLatch1, mkdirsTriggerLatch1);
        SyncedFileSystem fs2 = new SyncedFileSystem(deleteAwaitLatch2, mkdirsAwaitLatch2, deletetriggerLatch2, mkdirsTriggerLatch2);
        FileCreator thread1 = new FileCreator((FileSystem)fs1, path1);
        FileCreator thread2 = new FileCreator((FileSystem)fs2, path2);
        thread1.start();
        thread2.start();
        if (useAwaits) {
            deleteAwaitLatch1.await();
            deleteAwaitLatch2.await();
        } else {
            Thread.sleep(5L);
        }
        mkdirsTriggerLatch1.trigger();
        deleteTriggerLatch1.trigger();
        if (useAwaits) {
            createAwaitLatch.await();
        } else {
            Thread.sleep(100L);
        }
        deletetriggerLatch2.trigger();
        if (useAwaits) {
            mkdirsAwaitLatch2.await();
        } else {
            Thread.sleep(5L);
        }
        createTriggerLatch.trigger();
        if (useAwaits) {
            thread1.sync();
        } else {
            Thread.sleep(5L);
        }
        mkdirsTriggerLatch2.trigger();
        thread1.sync();
        thread2.sync();
    }

    private static final class NoOpLock
    extends ReentrantLock {
        private NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public void unlock() {
        }
    }

    private static class SyncedFileSystem
    extends LocalFileSystem {
        private final OneShotLatch deleteTriggerLatch;
        private final OneShotLatch mkdirsTriggerLatch;
        private final OneShotLatch deleteAwaitLatch;
        private final OneShotLatch mkdirsAwaitLatch;

        SyncedFileSystem(OneShotLatch deleteTriggerLatch, OneShotLatch mkdirsTriggerLatch, OneShotLatch deleteAwaitLatch, OneShotLatch mkdirsAwaitLatch) {
            this.deleteTriggerLatch = deleteTriggerLatch;
            this.mkdirsTriggerLatch = mkdirsTriggerLatch;
            this.deleteAwaitLatch = deleteAwaitLatch;
            this.mkdirsAwaitLatch = mkdirsAwaitLatch;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            this.deleteTriggerLatch.trigger();
            try {
                this.deleteAwaitLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupted");
            }
            return super.delete(f, recursive);
        }

        public boolean mkdirs(Path f) throws IOException {
            this.mkdirsTriggerLatch.trigger();
            try {
                this.mkdirsAwaitLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupted");
            }
            return super.mkdirs(f);
        }
    }

    private static class FileCreator
    extends CheckedThread {
        private final FileSystem fs;
        private final Path path;

        FileCreator(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }

        public void go() throws Exception {
            this.fs.initOutPathLocalFS(this.path.getParent(), FileSystem.WriteMode.OVERWRITE, true);
            try (FSDataOutputStream out = this.fs.create(this.path, FileSystem.WriteMode.OVERWRITE);){
                out.write(11);
            }
        }
    }
}

