/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class SimpleVersionedSerializationTest {
    @Test
    public void testSerializationRoundTrip() throws IOException {
        TestStringSerializer utfEncoder = new TestStringSerializer();
        String testString = "dugfakgs";
        DataOutputSerializer out = new DataOutputSerializer(32);
        SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)utfEncoder, (Object)"dugfakgs", (DataOutputView)out);
        byte[] outBytes = out.getCopyOfBuffer();
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)utfEncoder, (Object)"dugfakgs");
        Assert.assertArrayEquals((byte[])bytes, (byte[])outBytes);
        DataInputDeserializer in = new DataInputDeserializer(bytes);
        String deserialized = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)utfEncoder, (DataInputView)in);
        String deserializedFromBytes = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)utfEncoder, (byte[])outBytes);
        Assert.assertEquals((Object)"dugfakgs", (Object)deserialized);
        Assert.assertEquals((Object)"dugfakgs", (Object)deserializedFromBytes);
    }

    @Test
    public void testSerializeEmpty() throws IOException {
        String testString = "beeeep!";
        SimpleVersionedSerializer<String> emptySerializer = new SimpleVersionedSerializer<String>(){

            public int getVersion() {
                return 42;
            }

            public byte[] serialize(String obj) throws IOException {
                return new byte[0];
            }

            public String deserialize(int version, byte[] serialized) throws IOException {
                Assert.assertEquals((long)42L, (long)version);
                Assert.assertEquals((long)0L, (long)serialized.length);
                return "beeeep!";
            }
        };
        DataOutputSerializer out = new DataOutputSerializer(32);
        SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)emptySerializer, (Object)"abc", (DataOutputView)out);
        byte[] outBytes = out.getCopyOfBuffer();
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)emptySerializer, (Object)"abc");
        Assert.assertArrayEquals((byte[])bytes, (byte[])outBytes);
        DataInputDeserializer in = new DataInputDeserializer(bytes);
        String deserialized = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)emptySerializer, (DataInputView)in);
        String deserializedFromBytes = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)emptySerializer, (byte[])outBytes);
        Assert.assertEquals((Object)"beeeep!", (Object)deserialized);
        Assert.assertEquals((Object)"beeeep!", (Object)deserializedFromBytes);
    }

    @Test
    public void testListSerializationRoundTrip() throws IOException {
        TestStringSerializer utfEncoder = new TestStringSerializer();
        ImmutableList datums = ImmutableList.of((Object)"beeep!", (Object)"beep!!!");
        DataOutputSerializer out = new DataOutputSerializer(32);
        SimpleVersionedSerialization.writeVersionAndSerializeList((SimpleVersionedSerializer)utfEncoder, (List)datums, (DataOutputView)out);
        byte[] outBytes = out.getCopyOfBuffer();
        DataInputDeserializer in = new DataInputDeserializer(outBytes);
        List deserialized = SimpleVersionedSerialization.readVersionAndDeserializeList((SimpleVersionedSerializer)utfEncoder, (DataInputView)in);
        Assert.assertEquals((Object)datums, (Object)deserialized);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnderflow() throws Exception {
        SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)new TestStringSerializer(), (byte[])new byte[7]);
    }

    private static final class TestStringSerializer
    implements SimpleVersionedSerializer<String> {
        private static final int VERSION = 0x3FFFFFFF;

        private TestStringSerializer() {
        }

        public int getVersion() {
            return 0x3FFFFFFF;
        }

        public byte[] serialize(String str) throws IOException {
            return str.getBytes(StandardCharsets.UTF_8);
        }

        public String deserialize(int version, byte[] serialized) throws IOException {
            Assert.assertEquals((long)0x3FFFFFFFL, (long)version);
            return new String(serialized, StandardCharsets.UTF_8);
        }
    }
}

