/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.core.plugin.PluginConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableMap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PluginConfigTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static Map<String, String> oldEnvVariables;

    @BeforeClass
    public static void setup() {
        oldEnvVariables = System.getenv();
    }

    @After
    public void teardown() {
        if (oldEnvVariables != null) {
            CommonTestUtils.setEnv(oldEnvVariables, (boolean)true);
        }
    }

    @Test
    public void getPluginsDir_existingDirectory_returnsDirectoryFile() throws IOException {
        File pluginsDirectory = temporaryFolder.newFolder();
        ImmutableMap envVariables = ImmutableMap.of((Object)"FLINK_PLUGINS_DIR", (Object)pluginsDirectory.getAbsolutePath());
        CommonTestUtils.setEnv((Map)envVariables);
        Assert.assertThat(PluginConfig.getPluginsDir().get(), (Matcher)Matchers.is((Object)pluginsDirectory));
    }

    @Test
    public void getPluginsDir_nonExistingDirectory_returnsEmpty() {
        ImmutableMap envVariables = ImmutableMap.of((Object)"FLINK_PLUGINS_DIR", (Object)new File(temporaryFolder.getRoot().getAbsoluteFile(), "should_not_exist").getAbsolutePath());
        CommonTestUtils.setEnv((Map)envVariables);
        Assert.assertFalse((boolean)PluginConfig.getPluginsDir().isPresent());
    }
}

