/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.parser.DoubleValueParser;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.ParserTestBase;

public class DoubleValueParserTest
extends ParserTestBase<DoubleValue> {
    @Override
    public String[] getValidTestValues() {
        return new String[]{"0", "0.0", "123.4", "0.124", ".623", "1234", "-12.34", String.valueOf(Double.MAX_VALUE), String.valueOf(Double.MIN_VALUE), String.valueOf(Double.NEGATIVE_INFINITY), String.valueOf(Double.POSITIVE_INFINITY), String.valueOf(Double.NaN), "1.234E2", "1.234e3", "1.234E-2", "1239"};
    }

    public DoubleValue[] getValidTestResults() {
        return new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(123.4), new DoubleValue(0.124), new DoubleValue(0.623), new DoubleValue(1234.0), new DoubleValue(-12.34), new DoubleValue(Double.MAX_VALUE), new DoubleValue(Double.MIN_VALUE), new DoubleValue(Double.NEGATIVE_INFINITY), new DoubleValue(Double.POSITIVE_INFINITY), new DoubleValue(Double.NaN), new DoubleValue(123.4), new DoubleValue(1234.0), new DoubleValue(0.01234), new DoubleValue(1239.0)};
    }

    @Override
    public String[] getInvalidTestValues() {
        return new String[]{"a", "123abc4", "-57-6", "7-877678", " 1", "2 ", " ", "\t"};
    }

    @Override
    public boolean allowsEmptyField() {
        return false;
    }

    @Override
    public FieldParser<DoubleValue> getParser() {
        return new DoubleValueParser();
    }

    @Override
    public Class<DoubleValue> getTypeClass() {
        return DoubleValue.class;
    }
}

