/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.net.URL;
import java.util.function.Consumer;
import org.apache.flink.util.ClassLoaderUtil;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FlinkUserCodeClassLoadersTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public static final String USER_CLASS = "UserClass";
    public static final String USER_CLASS_CODE = "import java.io.Serializable;\npublic class UserClass implements Serializable {}";
    private static File userJar;

    @BeforeClass
    public static void prepare() throws Exception {
        userJar = UserClassLoaderJarTestUtils.createJarFile(temporaryFolder.newFolder("test-jar"), "test-classloader.jar", USER_CLASS, USER_CLASS_CODE);
    }

    @Test
    public void testParentFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, parentClassLoader);
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader1);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader2);
        Assert.assertEquals(clazz1, clazz2);
        Assert.assertEquals(clazz1, clazz3);
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    public void testChildFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader1);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader2);
        Assert.assertNotEquals(clazz1, clazz2);
        Assert.assertNotEquals(clazz1, clazz3);
        Assert.assertNotEquals(clazz2, clazz3);
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    public void testRepeatedChildFirstClassLoading() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz4 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Assert.assertNotEquals(clazz1, clazz2);
        Assert.assertEquals(clazz2, clazz3);
        Assert.assertEquals(clazz2, clazz4);
        childClassLoader.close();
    }

    @Test
    public void testRepeatedParentFirstPatternClass() throws Exception {
        String className = FlinkUserCodeClassLoadersTest.class.getName();
        String parentFirstPattern = className.substring(0, className.lastIndexOf(46));
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[]{parentFirstPattern}, (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
        Class<?> clazz1 = Class.forName(className, false, parentClassLoader);
        Class<?> clazz2 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz3 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Class<?> clazz4 = Class.forName(className, false, (ClassLoader)childClassLoader);
        Assert.assertEquals(clazz1, clazz2);
        Assert.assertEquals(clazz1, clazz3);
        Assert.assertEquals(clazz1, clazz4);
        childClassLoader.close();
    }

    @Test
    public void testGetClassLoaderInfo() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        String formattedURL = ClassLoaderUtil.formatURL((URL)childCodePath);
        Assert.assertEquals((Object)ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)childClassLoader), (Object)("URL ClassLoader:" + formattedURL));
        childClassLoader.close();
    }

    @Test
    public void testGetClassLoaderInfoWithClassLoaderClosed() throws Exception {
        ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        childClassLoader.close();
        Assert.assertThat((Object)ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)childClassLoader), (Matcher)Matchers.startsWith((String)"Cannot access classloader info due to an exception."));
    }

    private static MutableURLClassLoader createParentFirstClassLoader(URL childCodePath, ClassLoader parentClassLoader) {
        return FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
    }

    private static MutableURLClassLoader createChildFirstClassLoader(URL childCodePath, ClassLoader parentClassLoader) {
        return FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{childCodePath}, (ClassLoader)parentClassLoader, (String[])new String[0], (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
    }

    @Test
    public void testClosingOfClassloader() throws Exception {
        String className = ClassToLoad.class.getName();
        ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader childClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, parentClassLoader);
        Class<?> loadedClass = childClassLoader.loadClass(className);
        Assert.assertNotSame(ClassToLoad.class, loadedClass);
        childClassLoader.close();
        this.expectedException.expect(CoreMatchers.isA(IllegalStateException.class));
        childClassLoader.loadClass(className);
    }

    @Test
    public void testParallelCapable() {
        Assert.assertTrue((boolean)TestParentFirstClassLoader.isParallelCapable);
    }

    @Test
    public void testParentFirstClassLoadingByAddURL() throws Exception {
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader parentClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, ((Object)((Object)this)).getClass().getClassLoader());
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createParentFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader1);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader2);
        parentClassLoader.addURL(userJar.toURI().toURL());
        Class<?> clazz1 = Class.forName(USER_CLASS, false, (ClassLoader)parentClassLoader);
        Class<?> clazz2 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader1);
        Class<?> clazz3 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader2);
        Assert.assertEquals(clazz1, clazz2);
        Assert.assertEquals(clazz1, clazz3);
        parentClassLoader.close();
        childClassLoader1.close();
        childClassLoader2.close();
    }

    @Test
    public void testChildFirstClassLoadingByAddURL() throws Exception {
        URL childCodePath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        MutableURLClassLoader parentClassLoader = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, ((Object)((Object)this)).getClass().getClassLoader());
        MutableURLClassLoader childClassLoader1 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        MutableURLClassLoader childClassLoader2 = FlinkUserCodeClassLoadersTest.createChildFirstClassLoader(childCodePath, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)parentClassLoader);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader1);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)childClassLoader2);
        URL userJarURL = userJar.toURI().toURL();
        childClassLoader1.addURL(userJarURL);
        childClassLoader2.addURL(userJarURL);
        this.assertClassNotFoundException(USER_CLASS, false, (ClassLoader)parentClassLoader);
        Class<?> clazz1 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader1);
        Class<?> clazz2 = Class.forName(USER_CLASS, false, (ClassLoader)childClassLoader2);
        Assert.assertNotEquals(clazz1, clazz2);
        parentClassLoader.close();
        childClassLoader1.close();
        childClassLoader2.close();
    }

    private void assertClassNotFoundException(String className, boolean initialize, ClassLoader classLoader) {
        try {
            Class.forName(className, initialize, classLoader);
            Assertions.fail((String)"Should fail.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class ClassToLoad {
        private ClassToLoad() {
        }
    }

    private static class TestParentFirstClassLoader
    extends FlinkUserCodeClassLoaders.ParentFirstClassLoader {
        public static boolean isParallelCapable = ClassLoader.registerAsParallelCapable();

        TestParentFirstClassLoader() {
            super(null, null, null);
        }
    }
}

