/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.util.LambdaUtil;
import org.junit.Assert;
import org.junit.Test;

public class LambdaUtilTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunWithContextClassLoaderRunnable() throws Exception {
        ClassLoader aPrioriContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader original = new URLClassLoader(new URL[0]);
            URLClassLoader temp = new URLClassLoader(new URL[0]);
            Thread.currentThread().setContextClassLoader(original);
            LambdaUtil.withContextClassLoader((ClassLoader)temp, () -> Assert.assertSame((Object)temp, (Object)Thread.currentThread().getContextClassLoader()));
            Assert.assertSame((Object)original, (Object)Thread.currentThread().getContextClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(aPrioriContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunWithContextClassLoaderSupplier() throws Exception {
        ClassLoader aPrioriContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader original = new URLClassLoader(new URL[0]);
            URLClassLoader temp = new URLClassLoader(new URL[0]);
            Thread.currentThread().setContextClassLoader(original);
            LambdaUtil.withContextClassLoader((ClassLoader)temp, () -> {
                Assert.assertSame((Object)temp, (Object)Thread.currentThread().getContextClassLoader());
                return true;
            });
            Assert.assertSame((Object)original, (Object)Thread.currentThread().getContextClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(aPrioriContextClassLoader);
        }
    }
}

