/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.LinkedHashMap;
import org.apache.flink.util.LinkedOptionalMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LinkedOptionalMapTest {
    @Test
    public void usageExample() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", String.class, (Object)"a string class");
        map.put("scala.Option", null, (Object)"a scala Option");
        map.put("java.lang.Boolean", Boolean.class, null);
        Assert.assertThat((Object)map.keyNames(), (Matcher)Matchers.hasItems((Object[])new String[]{"java.lang.String", "scala.Option"}));
        Assert.assertThat((Object)map.absentKeysOrValues(), (Matcher)Matchers.hasItems((Object[])new String[]{"scala.Option", "java.lang.Boolean"}));
    }

    @Test
    public void overridingKeyWithTheSameKeyName() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", null, (Object)"a string class");
        map.put("java.lang.String", String.class, (Object)"a string class");
        Assert.assertThat((Object)map.absentKeysOrValues(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void overridingKeysAndValuesWithTheSameKeyName() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", null, null);
        map.put("java.lang.String", String.class, (Object)"a string class");
        Assert.assertThat((Object)map.absentKeysOrValues(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void overridingAValueWithMissingKeyShouldBeConsideredAsAbsent() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", null, null);
        map.put("java.lang.String", null, (Object)"a string class");
        Assert.assertThat((Object)map.absentKeysOrValues(), (Matcher)Matchers.hasItem((Object)"java.lang.String"));
    }

    @Test
    public void mergingMapsWithPresentEntriesLeavesNoAbsentKeyNames() {
        LinkedOptionalMap first = new LinkedOptionalMap();
        first.put("b", null, null);
        first.put("c", String.class, null);
        LinkedOptionalMap second = new LinkedOptionalMap();
        second.put("a", String.class, (Object)"aaa");
        second.put("b", String.class, (Object)"bbb");
        second.put("c", Void.class, (Object)"ccc");
        second.put("d", String.class, (Object)"ddd");
        first.putAll(second);
        Assert.assertThat((Object)first.absentKeysOrValues(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void mergingMapsPreserversTheOrderOfTheOriginalMap() {
        LinkedOptionalMap first = new LinkedOptionalMap();
        first.put("b", null, null);
        first.put("c", String.class, null);
        LinkedOptionalMap second = new LinkedOptionalMap();
        second.put("a", String.class, (Object)"aaa");
        second.put("b", String.class, (Object)"bbb");
        second.put("c", Void.class, (Object)"ccc");
        second.put("d", String.class, (Object)"ddd");
        first.putAll(second);
        Assert.assertThat((Object)first.keyNames(), (Matcher)Matchers.contains((Object[])new String[]{"b", "c", "a", "d"}));
    }

    @Test
    public void mergingToEmpty() {
        LinkedOptionalMap first = new LinkedOptionalMap();
        LinkedOptionalMap second = new LinkedOptionalMap();
        second.put("a", String.class, (Object)"aaa");
        second.put("b", String.class, (Object)"bbb");
        second.put("c", Void.class, (Object)"ccc");
        second.put("d", String.class, (Object)"ddd");
        first.putAll(second);
        Assert.assertThat((Object)first.keyNames(), (Matcher)Matchers.contains((Object[])new String[]{"a", "b", "c", "d"}));
    }

    @Test(expected=IllegalStateException.class)
    public void unwrapOptionalsWithMissingValueThrows() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("a", String.class, null);
        map.unwrapOptionals();
    }

    @Test(expected=IllegalStateException.class)
    public void unwrapOptionalsWithMissingKeyThrows() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("a", null, (Object)"blabla");
        map.unwrapOptionals();
    }

    @Test
    public void unwrapOptionalsPreservesOrder() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("a", String.class, (Object)"aaa");
        map.put("b", Boolean.class, (Object)"bbb");
        LinkedHashMap m = map.unwrapOptionals();
        Assert.assertThat(m.keySet(), (Matcher)Matchers.contains((Object[])new Class[]{String.class, Boolean.class}));
        Assert.assertThat(m.values(), (Matcher)Matchers.contains((Object[])new String[]{"aaa", "bbb"}));
    }

    @Test
    public void testPrefix() {
        LinkedOptionalMap left = new LinkedOptionalMap();
        left.put("a", String.class, (Object)"aaa");
        left.put("b", String.class, (Object)"aaa");
        LinkedOptionalMap right = new LinkedOptionalMap(left);
        right.put("c", Boolean.class, (Object)"bbb");
        Assert.assertTrue((boolean)LinkedOptionalMap.isLeftPrefixOfRight((LinkedOptionalMap)left, (LinkedOptionalMap)right));
    }

    @Test
    public void testNonPrefix() {
        LinkedOptionalMap left = new LinkedOptionalMap();
        left.put("a", String.class, (Object)"aaa");
        left.put("c", String.class, (Object)"aaa");
        LinkedOptionalMap right = new LinkedOptionalMap();
        right.put("b", Boolean.class, (Object)"bbb");
        right.put("c", Boolean.class, (Object)"bbb");
        Assert.assertFalse((boolean)LinkedOptionalMap.isLeftPrefixOfRight((LinkedOptionalMap)left, (LinkedOptionalMap)right));
    }

    @Test
    public void demoMergeResult() {
        LinkedOptionalMap left = new LinkedOptionalMap();
        left.put("b", null, null);
        left.put("c", String.class, null);
        LinkedOptionalMap right = new LinkedOptionalMap();
        right.put("b", String.class, (Object)"bbb");
        right.put("c", Void.class, (Object)"ccc");
        right.put("a", Boolean.class, (Object)"aaa");
        right.put("d", Long.class, (Object)"ddd");
        LinkedOptionalMap.MergeResult result = LinkedOptionalMap.mergeRightIntoLeft((LinkedOptionalMap)left, (LinkedOptionalMap)right);
        Assert.assertThat((Object)result.hasMissingKeys(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)result.isOrderedSubset(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)result.missingKeys(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        LinkedHashMap merged = result.getMerged();
        Assert.assertThat(merged.keySet(), (Matcher)Matchers.contains((Object[])new Class[]{String.class, Void.class, Boolean.class, Long.class}));
    }
}

