/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.TernaryBoolean;
import org.junit.Assert;
import org.junit.Test;

public class TernaryBooleanTest {
    @Test
    public void testWithDefault() {
        Assert.assertTrue((boolean)TernaryBoolean.TRUE.getOrDefault(true));
        Assert.assertTrue((boolean)TernaryBoolean.TRUE.getOrDefault(false));
        Assert.assertFalse((boolean)TernaryBoolean.FALSE.getOrDefault(true));
        Assert.assertFalse((boolean)TernaryBoolean.FALSE.getOrDefault(false));
        Assert.assertTrue((boolean)TernaryBoolean.UNDEFINED.getOrDefault(true));
        Assert.assertFalse((boolean)TernaryBoolean.UNDEFINED.getOrDefault(false));
    }

    @Test
    public void testResolveUndefined() {
        Assert.assertEquals((Object)TernaryBoolean.TRUE, (Object)TernaryBoolean.TRUE.resolveUndefined(true));
        Assert.assertEquals((Object)TernaryBoolean.TRUE, (Object)TernaryBoolean.TRUE.resolveUndefined(false));
        Assert.assertEquals((Object)TernaryBoolean.FALSE, (Object)TernaryBoolean.FALSE.resolveUndefined(true));
        Assert.assertEquals((Object)TernaryBoolean.FALSE, (Object)TernaryBoolean.FALSE.resolveUndefined(false));
        Assert.assertEquals((Object)TernaryBoolean.TRUE, (Object)TernaryBoolean.UNDEFINED.resolveUndefined(true));
        Assert.assertEquals((Object)TernaryBoolean.FALSE, (Object)TernaryBoolean.UNDEFINED.resolveUndefined(false));
    }

    @Test
    public void testToBoolean() {
        Assert.assertTrue((Boolean.TRUE == TernaryBoolean.TRUE.getAsBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((Boolean.FALSE == TernaryBoolean.FALSE.getAsBoolean() ? 1 : 0) != 0);
        Assert.assertNull((Object)TernaryBoolean.UNDEFINED.getAsBoolean());
    }

    @Test
    public void testFromBoolean() {
        Assert.assertEquals((Object)TernaryBoolean.TRUE, (Object)TernaryBoolean.fromBoolean((boolean)true));
        Assert.assertEquals((Object)TernaryBoolean.FALSE, (Object)TernaryBoolean.fromBoolean((boolean)false));
    }

    @Test
    public void testFromBoxedBoolean() {
        Assert.assertEquals((Object)TernaryBoolean.TRUE, (Object)TernaryBoolean.fromBoxedBoolean((Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)TernaryBoolean.FALSE, (Object)TernaryBoolean.fromBoxedBoolean((Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)TernaryBoolean.UNDEFINED, (Object)TernaryBoolean.fromBoxedBoolean(null));
    }
}

