/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class DefaultFilterTest {
    private final boolean shouldFilter;
    private final String filePath;

    @Parameters
    private static Collection<Object[]> data() {
        return Arrays.asList({"file.txt", false}, {".file.txt", true}, {"dir/.file.txt", true}, {".dir/file.txt", false}, {"_file.txt", true}, {"dir/_file.txt", true}, {"_dir/file.txt", false}, {"_COPYING_", true}, {"dir/_COPYING_", true}, {"_COPYING_/file.txt", false});
    }

    DefaultFilterTest(String filePath, boolean shouldFilter) {
        this.filePath = filePath;
        this.shouldFilter = shouldFilter;
    }

    @TestTemplate
    void test() {
        FilePathFilter defaultFilter = FilePathFilter.createDefaultFilter();
        Path path = new Path(this.filePath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)defaultFilter.filterPath(path)).as("File: " + this.filePath, new Object[0])).isEqualTo(this.shouldFilter);
    }
}

