/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.api.common.io.GlobFilePathFilter;
import org.apache.flink.api.common.io.InputStreamFSInputWrapper;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.testutils.TestFileUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.IntValue;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileInputFormatTest {
    @TempDir
    private java.nio.file.Path temporaryFolder;

    FileInputFormatTest() {
    }

    @Test
    void testGetPathWithoutSettingFirst() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        ((ObjectAssert)Assertions.assertThat((Object)format.getFilePath()).as("Path should be null.", new Object[0])).isNull();
    }

    @Test
    void testGetPathsWithoutSettingFirst() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        Object[] paths = format.getFilePaths();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])paths).as("Paths should not be null.", new Object[0])).isNotNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])paths).as("Paths should be empty.", new Object[0])).isEmpty();
    }

    @Test
    void testToStringWithoutPathSet() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        ((AbstractStringAssert)Assertions.assertThat((String)format.toString()).as("The toString() should be correct.", new Object[0])).isEqualTo("File Input (unknown file)");
    }

    @Test
    void testSetPathsNull() {
        Assertions.assertThatThrownBy(() -> new MultiDummyFileInputFormat().setFilePaths(new String[]{null})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetPathNullString() {
        Assertions.assertThatThrownBy(() -> new DummyFileInputFormat().setFilePath(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetPathNullPath() {
        Assertions.assertThatThrownBy(() -> new DummyFileInputFormat().setFilePath(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetPathsOnePathNull() {
        Assertions.assertThatThrownBy(() -> new MultiDummyFileInputFormat().setFilePaths(new String[]{"/an/imaginary/path", null})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetPathsEmptyArray() {
        Assertions.assertThatThrownBy(() -> new MultiDummyFileInputFormat().setFilePaths(new String[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetPath() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath("/some/imaginary/path");
        Assertions.assertThat((String)"/some/imaginary/path").isEqualTo(format.getFilePath().toString());
    }

    @Test
    void testSetPathOnMulti() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        format.setFilePath("/an/imaginary/path");
        Object[] filePaths = format.getFilePaths();
        Assertions.assertThat((Object[])filePaths).hasSize(1);
        Assertions.assertThat((String)filePaths[0].toUri().toString()).isEqualTo("/an/imaginary/path");
        Assertions.assertThat((String)format.filePath.toUri().toString()).isEqualTo("/an/imaginary/path");
    }

    @Test
    void testSetPathsSingleWithMulti() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        format.setFilePaths(new String[]{"/an/imaginary/path"});
        Object[] filePaths = format.getFilePaths();
        Assertions.assertThat((Object[])filePaths).hasSize(1);
        Assertions.assertThat((String)filePaths[0].toUri().toString()).isEqualTo("/an/imaginary/path");
        Assertions.assertThat((String)format.filePath.toUri().toString()).isEqualTo("/an/imaginary/path");
    }

    @Test
    void testSetPathsMulti() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        format.setFilePaths(new String[]{"/an/imaginary/path", "/an/imaginary/path2"});
        Object[] filePaths = format.getFilePaths();
        Assertions.assertThat((Object[])filePaths).hasSize(2);
        Assertions.assertThat((String)filePaths[0].toUri().toString()).isEqualTo("/an/imaginary/path");
        Assertions.assertThat((String)filePaths[1].toUri().toString()).isEqualTo("/an/imaginary/path2");
    }

    @Test
    void testMultiPathSetOnSinglePathIF() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        Assertions.assertThatThrownBy(() -> format.setFilePaths(new String[]{"/an/imaginary/path", "/an/imaginary/path2"})).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testMultiPathSetOnSinglePathIF2() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        Assertions.assertThatThrownBy(() -> format.setFilePaths(new Path[]{new Path("/an/imaginary/path"), new Path("/an/imaginary/path2")})).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testSinglePathGetOnMultiPathIF() {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        String myPath = "/an/imaginary/path";
        String myPath2 = "/an/imaginary/path2";
        format.setFilePaths(new String[]{"/an/imaginary/path", "/an/imaginary/path2"});
        Assertions.assertThatThrownBy(() -> ((MultiDummyFileInputFormat)format).getFilePath()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testSetFileViaConfiguration() {
        DummyFileInputFormat format = new DummyFileInputFormat();
        String filePath = "file:///some/none/existing/directory/";
        Configuration conf = new Configuration();
        conf.setString("input.file.path", "file:///some/none/existing/directory/");
        format.configure(conf);
        Assertions.assertThat((Object)format.getFilePath()).isEqualTo((Object)new Path("file:///some/none/existing/directory/"));
    }

    @Test
    void testSetFileViaConfigurationEmptyPath() {
        Assertions.assertThatThrownBy(() -> {
            DummyFileInputFormat format = new DummyFileInputFormat();
            String filePath = null;
            Configuration conf = new Configuration();
            conf.setString("input.file.path", filePath);
            format.configure(conf);
        }).isInstanceOf(RuntimeException.class);
    }

    @Test
    void testCreateInputSplitSingleFile() throws IOException {
        String tempFile = TestFileUtils.createTempFile("Hello World");
        DummyFileInputFormat fif = new DummyFileInputFormat();
        fif.setFilePath(tempFile);
        fif.configure(new Configuration());
        Object[] splits = fif.createInputSplits(2);
        Assertions.assertThat((Object[])splits).hasSize(2);
        Assertions.assertThat((String)splits[0].getPath().toString()).isEqualTo(tempFile);
        Assertions.assertThat((String)splits[1].getPath().toString()).isEqualTo(tempFile);
    }

    @Test
    void testCreateInputSplitMultiFiles() throws IOException {
        String tempFile1 = TestFileUtils.createTempFile(21L);
        String tempFile2 = TestFileUtils.createTempFile(22L);
        String tempFile3 = TestFileUtils.createTempFile(23L);
        MultiDummyFileInputFormat fif = new MultiDummyFileInputFormat();
        fif.setFilePaths(new String[]{tempFile1, tempFile2, tempFile3});
        fif.configure(new Configuration());
        Object[] splits = fif.createInputSplits(3);
        int numSplitsFile1 = 0;
        int numSplitsFile2 = 0;
        int numSplitsFile3 = 0;
        Assertions.assertThat((Object[])splits).hasSize(3);
        for (Object fis : splits) {
            Assertions.assertThat((long)fis.getStart()).isZero();
            if (fis.getPath().toString().equals(tempFile1)) {
                ++numSplitsFile1;
                Assertions.assertThat((long)fis.getLength()).isEqualTo(21L);
                continue;
            }
            if (fis.getPath().toString().equals(tempFile2)) {
                ++numSplitsFile2;
                Assertions.assertThat((long)fis.getLength()).isEqualTo(22L);
                continue;
            }
            if (fis.getPath().toString().equals(tempFile3)) {
                ++numSplitsFile3;
                Assertions.assertThat((long)fis.getLength()).isEqualTo(23L);
                continue;
            }
            Fail.fail((String)"Got split for unknown file.");
        }
        Assertions.assertThat((int)numSplitsFile1).isOne();
        Assertions.assertThat((int)numSplitsFile2).isOne();
        Assertions.assertThat((int)numSplitsFile3).isOne();
    }

    @Test
    void testGetStatisticsNonExistingFile() throws IOException {
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath("file:///some/none/existing/directory/");
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((ObjectAssert)Assertions.assertThat((Object)stats).as("The file statistics should be null.", new Object[0])).isNull();
    }

    @Test
    void testGetStatisticsOneFileNoCachedVersion() throws IOException {
        long SIZE = 512000L;
        String tempFile = TestFileUtils.createTempFile(512000L);
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(512000L);
    }

    @Test
    void testGetStatisticsMultipleFilesNoCachedVersion() throws IOException {
        long SIZE1 = 2077L;
        long SIZE2 = 31909L;
        long SIZE3 = 10L;
        long TOTAL = 33996L;
        String tempDir = TestFileUtils.createTempFileDir(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder), 2077L, 31909L, 10L);
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(tempDir);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(33996L);
    }

    @Test
    void testGetStatisticsOneFileWithCachedVersion() throws IOException {
        long SIZE = 50873L;
        long FAKE_SIZE = 10065L;
        String tempFile = TestFileUtils.createTempFile(50873L);
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(50873L);
        format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics newStats = format.getStatistics((BaseStatistics)stats);
        ((ObjectAssert)Assertions.assertThat((Object)stats).as("Statistics object was changed", new Object[0])).isSameAs((Object)newStats);
        format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics fakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics latest = format.getStatistics((BaseStatistics)fakeStats);
        ((AbstractLongAssert)Assertions.assertThat((long)latest.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(10065L);
        format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics outDatedFakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime() - 1L, 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics reGathered = format.getStatistics((BaseStatistics)outDatedFakeStats);
        ((AbstractLongAssert)Assertions.assertThat((long)reGathered.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(50873L);
    }

    @Test
    void testGetStatisticsMultipleFilesWithCachedVersion() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        long SIZE1 = 2077L;
        long SIZE2 = 31909L;
        long SIZE3 = 10L;
        long TOTAL = 33996L;
        long FAKE_SIZE = 10065L;
        File tempDirFile = TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder);
        String tempDir = tempDirFile.getAbsolutePath();
        String f1 = TestFileUtils.createTempFileInDirectory(tempDir, 2077L);
        long modTime1 = fs.getFileStatus(new Path(f1)).getModificationTime();
        String f2 = TestFileUtils.createTempFileInDirectory(tempDir, 31909L);
        long modTime2 = fs.getFileStatus(new Path(f2)).getModificationTime();
        String f3 = TestFileUtils.createTempFileInDirectory(tempDir, 10L);
        long modTime3 = fs.getFileStatus(new Path(f3)).getModificationTime();
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(tempDir);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(33996L);
        format = new DummyFileInputFormat();
        format.setFilePath(tempDir);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics newStats = format.getStatistics((BaseStatistics)stats);
        ((ObjectAssert)Assertions.assertThat((Object)stats).as("Statistics object was changed", new Object[0])).isSameAs((Object)newStats);
        format = new DummyFileInputFormat();
        format.setFilePath(tempDir);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics fakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics latest = format.getStatistics((BaseStatistics)fakeStats);
        ((AbstractLongAssert)Assertions.assertThat((long)latest.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(10065L);
        format = new DummyFileInputFormat();
        format.setFilePath(tempDir);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics outDatedFakeStats = new FileInputFormat.FileBaseStatistics(Math.min(Math.min(modTime1, modTime2), modTime3) - 1L, 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics reGathered = format.getStatistics((BaseStatistics)outDatedFakeStats);
        ((AbstractLongAssert)Assertions.assertThat((long)reGathered.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(33996L);
    }

    @Test
    void testGetStatisticsMultipleNonExistingFile() throws IOException {
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{"file:///some/none/existing/directory/", "file:///another/non/existing/directory/"});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((ObjectAssert)Assertions.assertThat((Object)stats).as("The file statistics should be null.", new Object[0])).isNull();
    }

    @Test
    void testGetStatisticsMultipleOneFileNoCachedVersion() throws IOException {
        long size1 = 512000L;
        String tempFile = TestFileUtils.createTempFile(512000L);
        long size2 = 517120L;
        String tempFile2 = TestFileUtils.createTempFile(517120L);
        long totalSize = 1029120L;
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempFile, tempFile2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(1029120L);
    }

    @Test
    void testGetStatisticsMultipleFilesMultiplePathsNoCachedVersion() throws IOException {
        long size1 = 2077L;
        long size2 = 31909L;
        long size3 = 10L;
        long totalSize123 = 33996L;
        String tempDir = TestFileUtils.createTempFileDir(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder), 2077L, 31909L, 10L);
        long size4 = 2051L;
        long size5 = 31902L;
        long size6 = 15L;
        long totalSize456 = 33968L;
        String tempDir2 = TestFileUtils.createTempFileDir(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder), 2051L, 31902L, 15L);
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempDir, tempDir2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(67964L);
    }

    @Test
    void testGetStatisticsMultipleOneFileWithCachedVersion() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        long size1 = 50873L;
        long fakeSize = 10065L;
        String tempFile1 = TestFileUtils.createTempFile(50873L);
        long lastModTime1 = fs.getFileStatus(new Path(tempFile1)).getModificationTime();
        long size2 = 52573L;
        String tempFile2 = TestFileUtils.createTempFile(52573L);
        long lastModTime2 = fs.getFileStatus(new Path(tempFile2)).getModificationTime();
        long sizeTotal = 103446L;
        MultiDummyFileInputFormat format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempFile1, tempFile2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        ((AbstractLongAssert)Assertions.assertThat((long)stats.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(103446L);
        format = new MultiDummyFileInputFormat();
        format.setFilePath(tempFile1);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics newStats = format.getStatistics((BaseStatistics)stats);
        ((ObjectAssert)Assertions.assertThat((Object)stats).as("Statistics object was changed", new Object[0])).isSameAs((Object)newStats);
        format = new MultiDummyFileInputFormat();
        format.setFilePath(tempFile1);
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics fakeStats = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics latest = format.getStatistics((BaseStatistics)fakeStats);
        ((AbstractLongAssert)Assertions.assertThat((long)latest.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(10065L);
        format = new MultiDummyFileInputFormat();
        format.setFilePaths(new String[]{tempFile1, tempFile2});
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics outDatedFakeStats = new FileInputFormat.FileBaseStatistics(Math.min(lastModTime1, lastModTime2) - 1L, 10065L, -1.0f);
        FileInputFormat.FileBaseStatistics reGathered = format.getStatistics((BaseStatistics)outDatedFakeStats);
        ((AbstractLongAssert)Assertions.assertThat((long)reGathered.getTotalInputSize()).as("The file size from the statistics is wrong.", new Object[0])).isEqualTo(103446L);
    }

    @Test
    void testFileInputFormatWithCompression() throws IOException {
        String tempFile = TestFileUtils.createTempFileDirForProvidedFormats(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder), FileInputFormat.getSupportedCompressionFormats());
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        Object[] splits = format.createInputSplits(2);
        Set supportedCompressionFormats = FileInputFormat.getSupportedCompressionFormats();
        Assertions.assertThat((Object[])splits).hasSameSizeAs((Iterable)supportedCompressionFormats);
        for (Object split : splits) {
            Assertions.assertThat((long)split.getLength()).isEqualTo(-1L);
            Assertions.assertThat((long)split.getStart()).isZero();
        }
        TestFileUtils.createTempFileInDirectory(tempFile.replace("file:", ""), "this creates a test file with a random extension (at least not .deflate)");
        DummyFileInputFormat formatMixed = new DummyFileInputFormat();
        formatMixed.setFilePath(tempFile);
        formatMixed.configure(new Configuration());
        Object[] splitsMixed = formatMixed.createInputSplits(2);
        Assertions.assertThat((Object[])splitsMixed).hasSize(supportedCompressionFormats.size() + 1);
        for (Object split : splitsMixed) {
            String extension = FileInputFormat.extractFileExtension((String)split.getPath().getName());
            if (supportedCompressionFormats.contains(extension)) {
                Assertions.assertThat((long)split.getLength()).isEqualTo(-1L);
                Assertions.assertThat((long)split.getStart()).isZero();
                continue;
            }
            Assertions.assertThat((long)split.getStart()).isEqualTo(0L);
            ((AbstractBooleanAssert)Assertions.assertThat((split.getLength() > 0L ? 1 : 0) != 0).as("split size not correct", new Object[0])).isTrue();
        }
    }

    @Test
    void testFileInputFormatWithCompressionFromFileSource() throws IOException {
        String tempFile = TestFileUtils.createTempFileDirForProvidedFormats(TempDirUtils.newFolder((java.nio.file.Path)this.temporaryFolder), FileInputFormat.getSupportedCompressionFormats());
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(tempFile);
        format.configure(new Configuration());
        List<FileInputSplit> splits = this.manuallyCreateSplits(tempFile);
        Set supportedCompressionFormats = FileInputFormat.getSupportedCompressionFormats();
        Assertions.assertThat(splits).hasSameSizeAs((Iterable)supportedCompressionFormats);
        for (FileInputSplit split : splits) {
            Assertions.assertThat((long)split.getStart()).isZero();
            format.open(split);
            Assertions.assertThat((boolean)format.compressedRead).isTrue();
            Assertions.assertThat((long)format.getSplitLength()).isEqualTo(-1L);
        }
    }

    private List<FileInputSplit> manuallyCreateSplits(String pathString) throws IOException {
        ArrayList<FileInputSplit> splits = new ArrayList<FileInputSplit>();
        Path path = new Path(pathString);
        FileSystem fs = path.getFileSystem();
        for (FileStatus file : fs.listStatus(path)) {
            splits.add(new FileInputSplit(0, file.getPath(), 0L, file.getLen(), null));
        }
        return splits;
    }

    @Test
    void testIgnoredUnderscoreFiles() throws IOException {
        String contents = "CONTENTS";
        File child1 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"dataFile1.txt");
        File child2 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"another_file.bin");
        File luigiFile = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"_luigi");
        File success = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"_SUCCESS");
        this.createTempFiles("CONTENTS".getBytes(ConfigConstants.DEFAULT_CHARSET), child1, child2, luigiFile, success);
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(this.temporaryFolder.toFile().getPath());
        format.configure(new Configuration());
        Object[] splits = format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(2);
        URI uri1 = splits[0].getPath().toUri();
        URI uri2 = splits[1].getPath().toUri();
        URI childUri1 = child1.toURI();
        URI childUri2 = child2.toURI();
        Assertions.assertThat((uri1.equals(childUri1) && uri2.equals(childUri2) || uri1.equals(childUri2) && uri2.equals(childUri1) ? 1 : 0) != 0).isTrue();
    }

    @Test
    void testExcludeFiles() throws IOException {
        String contents = "CONTENTS";
        File child1 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"dataFile1.txt");
        File child2 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"another_file.bin");
        File[] files = new File[]{child1, child2};
        this.createTempFiles("CONTENTS".getBytes(ConfigConstants.DEFAULT_CHARSET), files);
        Configuration configuration = new Configuration();
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(this.temporaryFolder.toFile().getPath());
        format.configure(configuration);
        format.setFilesFilter((FilePathFilter)new GlobFilePathFilter(Collections.singletonList("**"), Collections.singletonList("**/another_file.bin")));
        Object[] splits = format.createInputSplits(1);
        Assertions.assertThat((Object[])splits).hasSize(1);
        URI uri1 = splits[0].getPath().toUri();
        URI childUri1 = child1.toURI();
        Assertions.assertThat((URI)childUri1).isEqualTo((Object)uri1);
    }

    @Test
    void testReadMultiplePatterns() throws Exception {
        String contents = "CONTENTS";
        File child1 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"dataFile1.txt");
        File child2 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"another_file.bin");
        this.createTempFiles("CONTENTS".getBytes(ConfigConstants.DEFAULT_CHARSET), child1, child2);
        Configuration configuration = new Configuration();
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(this.temporaryFolder.toFile().getPath());
        format.configure(configuration);
        format.setFilesFilter((FilePathFilter)new GlobFilePathFilter(Collections.singletonList("**"), Arrays.asList("**/another_file.bin", "**/dataFile1.txt")));
        FileInputSplit[] splits = format.createInputSplits(1);
        Assertions.assertThat((int)splits.length).isZero();
    }

    @Test
    void testGetStatsIgnoredUnderscoreFiles() throws IOException {
        int SIZE = 2048;
        long TOTAL = 4096L;
        File child1 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"dataFile1.txt");
        File child2 = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"another_file.bin");
        File luigiFile = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"_luigi");
        File success = TempDirUtils.newFile((java.nio.file.Path)this.temporaryFolder, (String)"_SUCCESS");
        this.createTempFiles(new byte[2048], child1, child2, luigiFile, success);
        DummyFileInputFormat format = new DummyFileInputFormat();
        format.setFilePath(this.temporaryFolder.toFile().getPath());
        format.configure(new Configuration());
        FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
        Assertions.assertThat((long)stats.getTotalInputSize()).isEqualTo(4096L);
    }

    @Test
    void testDecorateInputStream() throws IOException {
        File tempFile = File.createTempFile("input-stream-decoration-test", "tmp");
        tempFile.deleteOnExit();
        int blockSize = 8;
        int numBlocks = 3;
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        for (int i = 0; i < 24; ++i) {
            fileOutputStream.write(new byte[]{(byte)i});
        }
        fileOutputStream.close();
        Configuration config = new Configuration();
        MyDecoratedInputFormat inputFormat = new MyDecoratedInputFormat();
        inputFormat.setFilePath(tempFile.toURI().toString());
        inputFormat.configure(config);
        inputFormat.openInputFormat();
        FileInputSplit[] inputSplits = inputFormat.createInputSplits(3);
        byte[] bytes = null;
        byte prev = 0;
        for (FileInputSplit inputSplit : inputSplits) {
            inputFormat.open(inputSplit);
            while (!inputFormat.reachedEnd()) {
                if ((bytes = (byte[])inputFormat.nextRecord(bytes)) == null) continue;
                Assertions.assertThat((byte[])bytes).isEqualTo((Object)new byte[]{prev = (byte)((byte)(prev - 1))});
            }
        }
        inputFormat.closeInputFormat();
    }

    private void createTempFiles(byte[] contents, File ... files) throws IOException {
        for (File child : files) {
            child.deleteOnExit();
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(child.toPath(), new OpenOption[0]));){
                out.write(contents);
            }
        }
    }

    private static final class InvertedInputStream
    extends InputStream {
        private final InputStream originalStream;

        private InvertedInputStream(InputStream originalStream) {
            this.originalStream = originalStream;
        }

        @Override
        public int read() throws IOException {
            int read = this.originalStream.read();
            return read == -1 ? -1 : ~read & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.originalStream.available();
        }
    }

    private static final class MyDecoratedInputFormat
    extends FileInputFormat<byte[]> {
        private static final long serialVersionUID = 1L;

        private MyDecoratedInputFormat() {
        }

        public boolean reachedEnd() throws IOException {
            return this.stream.getPos() >= this.splitStart + this.splitLength;
        }

        public byte[] nextRecord(byte[] reuse) throws IOException {
            int read = this.stream.read();
            if (read == -1) {
                throw new IllegalStateException();
            }
            return new byte[]{(byte)read};
        }

        protected FSDataInputStream decorateInputStream(FSDataInputStream inputStream, FileInputSplit fileSplit) throws Throwable {
            inputStream = super.decorateInputStream(inputStream, fileSplit);
            return new InputStreamFSInputWrapper((InputStream)new InvertedInputStream((InputStream)inputStream));
        }
    }

    private class MultiDummyFileInputFormat
    extends DummyFileInputFormat {
        private static final long serialVersionUID = 1L;

        private MultiDummyFileInputFormat() {
        }

        public boolean supportsMultiPaths() {
            return true;
        }
    }

    private static class DummyFileInputFormat
    extends FileInputFormat<IntValue> {
        private static final long serialVersionUID = 1L;
        private boolean compressedRead = false;

        private DummyFileInputFormat() {
        }

        public boolean reachedEnd() {
            return true;
        }

        public IntValue nextRecord(IntValue record) {
            return null;
        }

        public void open(FileInputSplit split) throws IOException {
            this.compressedRead = false;
            super.open(split);
        }

        protected FSDataInputStream decorateInputStream(FSDataInputStream inputStream, FileInputSplit fileSplit) {
            this.compressedRead = DummyFileInputFormat.getInflaterInputStreamFactory((String)DummyFileInputFormat.extractFileExtension((String)fileSplit.getPath().getName())) != null;
            return inputStream;
        }
    }
}

