/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import org.apache.flink.api.common.state.BroadcastStateDeclaration;
import org.apache.flink.api.common.state.MapStateDeclaration;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.StateDeclarations;
import org.apache.flink.api.common.typeinfo.TypeDescriptor;
import org.apache.flink.api.common.typeinfo.TypeDescriptors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MapStateDeclarationTest {
    MapStateDeclarationTest() {
    }

    @Test
    void testMapStateDeclarationName() {
        MapStateDeclaration mapStateDeclaration = StateDeclarations.mapStateBuilder((String)"mapState", (TypeDescriptor)TypeDescriptors.INT, (TypeDescriptor)TypeDescriptors.STRING).build();
        Assertions.assertThat((String)mapStateDeclaration.getName()).isEqualTo("mapState");
    }

    @Test
    void testMapStateDeclarationType() {
        MapStateDeclaration mapStateDeclaration = StateDeclarations.mapStateBuilder((String)"mapState", (TypeDescriptor)TypeDescriptors.INT, (TypeDescriptor)TypeDescriptors.STRING).build();
        Assertions.assertThat((Object)mapStateDeclaration.getKeyTypeDescriptor()).isEqualTo((Object)TypeDescriptors.INT);
        Assertions.assertThat((Object)mapStateDeclaration.getValueTypeDescriptor()).isEqualTo((Object)TypeDescriptors.STRING);
    }

    @Test
    void testMapStateDeclarationRedistribution() {
        MapStateDeclaration mapStateDeclaration = StateDeclarations.mapStateBuilder((String)"mapState", (TypeDescriptor)TypeDescriptors.INT, (TypeDescriptor)TypeDescriptors.STRING).build();
        Assertions.assertThat((Comparable)mapStateDeclaration.getRedistributionMode()).isEqualTo((Object)StateDeclaration.RedistributionMode.NONE);
    }

    @Test
    void testBroadcastStateDeclaration() {
        BroadcastStateDeclaration broadcastState = StateDeclarations.mapStateBuilder((String)"broadcastState", (TypeDescriptor)TypeDescriptors.INT, (TypeDescriptor)TypeDescriptors.STRING).buildBroadcast();
        Assertions.assertThat((Comparable)broadcastState.getRedistributionMode()).isEqualTo((Object)StateDeclaration.RedistributionMode.IDENTICAL);
        Assertions.assertThat((String)broadcastState.getName()).isEqualTo("broadcastState");
        Assertions.assertThat((Object)broadcastState.getKeyTypeDescriptor()).isEqualTo((Object)TypeDescriptors.INT);
        Assertions.assertThat((Object)broadcastState.getValueTypeDescriptor()).isEqualTo((Object)TypeDescriptors.STRING);
    }
}

