/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.EitherSerializer;
import org.apache.flink.types.Either;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;

class CompositeTypeSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    CompositeTypeSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("either-serializer", flinkVersion, EitherSerializerSetup.class, EitherSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("generic-array-serializer", flinkVersion, GenericArraySerializerSetup.class, GenericArraySerializerVerifier.class));
        return testSpecifications;
    }

    @Test
    void testUpgradeFromDeprecatedSnapshot() {
        GenericArraySerializer genericArraySerializer = new GenericArraySerializer(String.class, (TypeSerializer)StringSerializer.INSTANCE);
        GenericArraySerializerConfigSnapshot oldSnapshot = new GenericArraySerializerConfigSnapshot(genericArraySerializer);
        TypeSerializerSchemaCompatibility schemaCompatibility = genericArraySerializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)oldSnapshot);
        Assertions.assertThat((boolean)schemaCompatibility.isCompatibleAsIs()).isTrue();
    }

    public static final class GenericArraySerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<String[]> {
        @Override
        public TypeSerializer<String[]> createUpgradedSerializer() {
            return new GenericArraySerializer(String.class, (TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Condition<String[]> testDataCondition() {
            Object[] data = new String[]{"Apache", "Flink"};
            return new Condition(arg_0 -> GenericArraySerializerVerifier.lambda$testDataCondition$0((String[])data, arg_0), "data is " + Arrays.toString(data), new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<String[]>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }

        private static /* synthetic */ boolean lambda$testDataCondition$0(String[] data, String[] value) {
            return Arrays.equals(data, value);
        }
    }

    public static final class GenericArraySerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<String[]> {
        @Override
        public TypeSerializer<String[]> createPriorSerializer() {
            return new GenericArraySerializer(String.class, (TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public String[] createTestData() {
            return new String[]{"Apache", "Flink"};
        }
    }

    public static final class EitherSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Either<String, Integer>> {
        @Override
        public TypeSerializer<Either<String, Integer>> createUpgradedSerializer() {
            return new EitherSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        }

        @Override
        public Condition<Either<String, Integer>> testDataCondition() {
            return new Condition(value -> new Either.Left((Object)"ApacheFlink").equals(value), "value is Either.Left(\"ApacheFlink\")", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Either<String, Integer>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class EitherSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Either<String, Integer>> {
        @Override
        public TypeSerializer<Either<String, Integer>> createPriorSerializer() {
            return new EitherSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        }

        @Override
        public Either<String, Integer> createTestData() {
            return new Either.Left((Object)"ApacheFlink");
        }
    }
}

