/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.function.Predicate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.assertj.core.api.Condition;

public final class TypeSerializerConditions {
    private TypeSerializerConditions() {
    }

    public static <T> Condition<TypeSerializerSchemaCompatibility<T>> isCompatibleAsIs() {
        return new Condition(TypeSerializerSchemaCompatibility::isCompatibleAsIs, "type serializer schema that is a compatible as is", new Object[0]);
    }

    public static <T> Condition<TypeSerializerSchemaCompatibility<T>> isIncompatible() {
        return new Condition(TypeSerializerSchemaCompatibility::isIncompatible, "type serializer schema that is incompatible", new Object[0]);
    }

    public static <T> Condition<TypeSerializerSchemaCompatibility<T>> isCompatibleAfterMigration() {
        return new Condition(TypeSerializerSchemaCompatibility::isCompatibleAfterMigration, "type serializer schema that is compatible after migration", new Object[0]);
    }

    public static <T> Condition<TypeSerializerSchemaCompatibility<T>> isCompatibleWithReconfiguredSerializer() {
        return new Condition(TypeSerializerSchemaCompatibility::isCompatibleWithReconfiguredSerializer, "type serializer schema that is compatible with a reconfigured serializer", new Object[0]);
    }

    public static <T> Condition<TypeSerializerSchemaCompatibility<T>> isCompatibleWithReconfiguredSerializer(Predicate<? super TypeSerializer<T>> reconfiguredSerializerMatcher) {
        return new Condition(compatibility -> compatibility.isCompatibleWithReconfiguredSerializer() && reconfiguredSerializerMatcher.test((Object)compatibility.getReconfiguredSerializer()), "type serializer schema that is compatible with a reconfigured serializer matching " + reconfiguredSerializerMatcher, new Object[0]);
    }

    public static <T> Condition<TypeSerializerSchemaCompatibility<T>> hasSameCompatibilityAs(TypeSerializerSchemaCompatibility<T> expectedCompatibility) {
        return new Condition(actual -> actual.isCompatibleAsIs() == expectedCompatibility.isCompatibleAsIs() && actual.isIncompatible() == expectedCompatibility.isIncompatible() && actual.isCompatibleAfterMigration() == expectedCompatibility.isCompatibleAfterMigration() && actual.isCompatibleWithReconfiguredSerializer() == expectedCompatibility.isCompatibleWithReconfiguredSerializer(), "same compatibility as " + expectedCompatibility, new Object[0]);
    }
}

