/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.MapCreator;

class OuterMapCreator
implements MapCreator {
    OuterMapCreator() {
    }

    @Override
    public MapFunction<Integer, Integer> getMap() {
        return new OuterStaticClass().getMap();
    }

    static class OuterStaticClass
    implements MapCreator {
        OuterStaticClass() {
        }

        @Override
        public MapFunction<Integer, Integer> getMap() {
            InnerStaticClass innerClass = new InnerStaticClass();
            return innerClass.getMap();
        }

        static class InnerStaticClass
        implements MapCreator {
            InnerStaticClass() {
            }

            @Override
            public MapFunction<Integer, Integer> getMap() {
                return new MapFunction<Integer, Integer>(){

                    public Integer map(Integer value) throws Exception {
                        return value + 1;
                    }
                };
            }
        }
    }
}

