/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeExtractorInputFormatsTest {
    TypeExtractorInputFormatsTest() {
    }

    @Test
    void testExtractInputFormatType() {
        DummyFloatInputFormat format = new DummyFloatInputFormat();
        TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
        Assertions.assertThat((Object)typeInfo).isEqualTo((Object)BasicTypeInfo.FLOAT_TYPE_INFO);
    }

    @Test
    void testExtractDerivedInputFormatType() {
        GenericInputFormat format = new DerivedInputFormat();
        TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
        Assertions.assertThat((Object)typeInfo).isEqualTo((Object)BasicTypeInfo.SHORT_TYPE_INFO);
        format = new DerivedTupleInputFormat();
        typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
        Assertions.assertThat((boolean)typeInfo.isTupleType()).isTrue();
        Assertions.assertThat((Object)typeInfo).isInstanceOf(TupleTypeInfo.class);
        TupleTypeInfo tupleInfo = (TupleTypeInfo)typeInfo;
        Assertions.assertThat((int)tupleInfo.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)tupleInfo.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tupleInfo.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.SHORT_TYPE_INFO);
        Assertions.assertThat((Object)tupleInfo.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
    }

    @Test
    void testMultiLevelDerivedInputFormatType() {
        FinalRelativeInputFormat format = new FinalRelativeInputFormat();
        TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
        Assertions.assertThat((boolean)typeInfo.isTupleType()).isTrue();
        Assertions.assertThat((Object)typeInfo).isInstanceOf(TupleTypeInfo.class);
        TupleTypeInfo tupleInfo = (TupleTypeInfo)typeInfo;
        Assertions.assertThat((int)tupleInfo.getArity()).isEqualTo(3);
        Assertions.assertThat((Object)tupleInfo.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tupleInfo.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)tupleInfo.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
    }

    @Test
    void testQueryableFormatType() {
        QueryableInputFormat format = new QueryableInputFormat();
        TypeInformation typeInfo = TypeExtractor.getInputFormatTypes((InputFormat)format);
        Assertions.assertThat((Object)typeInfo).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
    }

    public static final class QueryableInputFormat
    implements InputFormat<Float, InputSplit>,
    ResultTypeQueryable<Double> {
        public void configure(Configuration parameters) {
        }

        public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
            return null;
        }

        public InputSplit[] createInputSplits(int minNumSplits) {
            return null;
        }

        public DefaultInputSplitAssigner getInputSplitAssigner(InputSplit[] splits) {
            return null;
        }

        public void open(InputSplit split) {
        }

        public boolean reachedEnd() {
            return false;
        }

        public Float nextRecord(Float reuse) throws IOException {
            return null;
        }

        public void close() {
        }

        public TypeInformation<Double> getProducedType() {
            return BasicTypeInfo.DOUBLE_TYPE_INFO;
        }
    }

    public static final class FinalRelativeInputFormat
    extends RelativeInputFormat<Integer> {
        @Override
        public Tuple3<String, Integer, Double> nextRecord(Tuple3<String, Integer, Double> reuse) {
            return null;
        }
    }

    public static class RelativeInputFormat<T>
    extends GenericInputFormat<Tuple3<String, T, Double>> {
        public boolean reachedEnd() {
            return false;
        }

        public Tuple3<String, T, Double> nextRecord(Tuple3<String, T, Double> reuse) {
            return null;
        }
    }

    public static final class DerivedTupleInputFormat
    extends GenericInputFormat<Tuple3<String, Short, Double>> {
        public boolean reachedEnd() {
            return false;
        }

        public Tuple3<String, Short, Double> nextRecord(Tuple3<String, Short, Double> reuse) {
            return null;
        }
    }

    public static final class DerivedInputFormat
    extends GenericInputFormat<Short> {
        public boolean reachedEnd() {
            return false;
        }

        public Short nextRecord(Short reuse) {
            return null;
        }
    }

    public static final class DummyFloatInputFormat
    implements InputFormat<Float, InputSplit> {
        public void configure(Configuration parameters) {
        }

        public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
            return null;
        }

        public InputSplit[] createInputSplits(int minNumSplits) {
            return null;
        }

        public DefaultInputSplitAssigner getInputSplitAssigner(InputSplit[] splits) {
            return null;
        }

        public void open(InputSplit split) {
        }

        public boolean reachedEnd() {
            return false;
        }

        public Float nextRecord(Float reuse) throws IOException {
            return null;
        }

        public void close() {
        }
    }
}

