/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class GlobalConfigurationTest {
    @TempDir
    private File tmpDir;

    GlobalConfigurationTest() {
    }

    @Test
    void testConfigurationWithLegacyYAML() throws FileNotFoundException {
        File confFile = new File(this.tmpDir, "flink-conf.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.println("###########################");
            pw.println("# Some : comments : to skip");
            pw.println("###########################");
            pw.println("mykey1: myvalue1");
            pw.println("mykey2       : myvalue2");
            pw.println("mykey3:myvalue3");
            pw.println(" some nonsense without colon and whitespace separator");
            pw.println(" :  ");
            pw.println("   ");
            pw.println(" ");
            pw.println("mykey4: myvalue4# some comments");
            pw.println("   mykey5    :    myvalue5    ");
            pw.println("mykey6: my: value6");
            pw.println("mykey7: ");
            pw.println(": myvalue8");
            pw.println("mykey9: myvalue9");
            pw.println("mykey9: myvalue10");
        }
        Configuration conf = GlobalConfiguration.loadConfiguration((String)this.tmpDir.getAbsolutePath());
        Assertions.assertThat((Collection)conf.keySet()).hasSize(6);
        Assertions.assertThat((String)conf.getString("mykey1", null)).isEqualTo("myvalue1");
        Assertions.assertThat((String)conf.getString("mykey1", null)).isEqualTo("myvalue1");
        Assertions.assertThat((String)conf.getString("mykey2", null)).isEqualTo("myvalue2");
        Assertions.assertThat((String)conf.getString("mykey3", "null")).isEqualTo("null");
        Assertions.assertThat((String)conf.getString("mykey4", null)).isEqualTo("myvalue4");
        Assertions.assertThat((String)conf.getString("mykey5", null)).isEqualTo("myvalue5");
        Assertions.assertThat((String)conf.getString("mykey6", null)).isEqualTo("my: value6");
        Assertions.assertThat((String)conf.getString("mykey7", "null")).isEqualTo("null");
        Assertions.assertThat((String)conf.getString("mykey8", "null")).isEqualTo("null");
        Assertions.assertThat((String)conf.getString("mykey9", null)).isEqualTo("myvalue10");
        GlobalConfiguration.setStandardYaml((boolean)true);
    }

    @Test
    void testConfigurationWithStandardYAML() throws FileNotFoundException {
        File confFile = new File(this.tmpDir, "config.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.println("Key1: ");
            pw.println("    Key2: v1");
            pw.println("    Key3: 'v2'");
            pw.println("Key4: 1");
            pw.println("Key5: '1'");
            pw.println("Key6: '*'");
            pw.println("Key7: true");
            pw.println("Key8: 'true'");
            pw.println("Key9: [a, b, '*', 1, '2',  true, 'true']");
            pw.println("Key10: {k1: v1, k2: '2', k3: 3}");
            pw.println("Key11: [{k1: v1, k2: '2', k3: 3}, {k4: true}]");
        }
        Configuration conf = GlobalConfiguration.loadConfiguration((String)this.tmpDir.getAbsolutePath());
        Assertions.assertThat((Collection)conf.keySet()).hasSize(12);
        Assertions.assertThat((String)((String)conf.get(ConfigOptions.key((String)"Key1.Key2").stringType().noDefaultValue()))).isEqualTo("v1");
        Assertions.assertThat((String)((String)conf.get(ConfigOptions.key((String)"Key1.Key3").stringType().noDefaultValue()))).isEqualTo("v2");
        Assertions.assertThat((Integer)((Integer)conf.get(ConfigOptions.key((String)"Key4").intType().noDefaultValue()))).isOne();
        Assertions.assertThat((String)((String)conf.get(ConfigOptions.key((String)"Key5").stringType().noDefaultValue()))).isEqualTo("1");
        Assertions.assertThat((String)((String)conf.get(ConfigOptions.key((String)"Key6").stringType().noDefaultValue()))).isEqualTo("*");
        Assertions.assertThat((Boolean)((Boolean)conf.get(ConfigOptions.key((String)"Key7").booleanType().noDefaultValue()))).isTrue();
        Assertions.assertThat((String)((String)conf.get(ConfigOptions.key((String)"Key8").stringType().noDefaultValue()))).isEqualTo("true");
        Assertions.assertThat((List)((List)conf.get(ConfigOptions.key((String)"Key9").stringType().asList().noDefaultValue()))).isEqualTo(Arrays.asList("a", "b", "*", "1", "2", "true", "true"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        map.put("k2", "2");
        map.put("k3", "3");
        Assertions.assertThat((Map)((Map)conf.get(ConfigOptions.key((String)"Key10").mapType().noDefaultValue()))).isEqualTo(map);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("k4", "true");
        Assertions.assertThat((List)((List)conf.get(ConfigOptions.key((String)"Key11").mapType().asList().noDefaultValue()))).isEqualTo(Arrays.asList(map, map2));
    }

    @Test
    void testFailIfNull() {
        Assertions.assertThatThrownBy(() -> GlobalConfiguration.loadConfiguration((String)null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testFailIfNotLoaded() {
        Assertions.assertThatThrownBy(() -> GlobalConfiguration.loadConfiguration((String)("/some/path/" + UUID.randomUUID()))).isInstanceOf(IllegalConfigurationException.class);
    }

    @Test
    void testInvalidConfiguration() {
        Assertions.assertThatThrownBy(() -> GlobalConfiguration.loadConfiguration((String)this.tmpDir.getAbsolutePath())).isInstanceOf(IllegalConfigurationException.class);
    }

    @Test
    void testInvalidLegacyYamlFile() throws IOException {
        File confFile = new File(this.tmpDir.getPath(), "flink-conf.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.append("invalid");
        }
        Assertions.assertThat((Object)GlobalConfiguration.loadConfiguration((String)this.tmpDir.getAbsolutePath())).isNotNull();
        GlobalConfiguration.setStandardYaml((boolean)true);
    }

    @Test
    void testInvalidStandardYamlFile() throws IOException {
        File confFile = new File(this.tmpDir.getPath(), "config.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.append("invalid");
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GlobalConfiguration.loadConfiguration((String)this.tmpDir.getAbsolutePath())).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(ClassCastException.class).satisfies(new ThrowingConsumer[]{e -> {
            Throwable cause = e.getCause();
            Assertions.assertThat((Throwable)cause).isNotNull();
            Assertions.assertThat((Throwable)cause).hasMessageContaining("java.lang.String");
            Assertions.assertThat((Throwable)cause).hasMessageContaining("java.util.Map");
        }});
    }

    @Test
    void testHiddenKey() {
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"password123")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"123pasSword")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"PasSword")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"Secret")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"polaris.client-secret")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"client-secret")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"service-key-json")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"auth.basic.password")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"auth.basic.token")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"avro-confluent.basic-auth.user-info")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"key.avro-confluent.basic-auth.user-info")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"value.avro-confluent.basic-auth.user-info")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"kafka.jaas.config")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"properties.ssl.truststore.password")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"properties.ssl.keystore.password")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"fs.azure.account.key.storageaccount123456.core.windows.net")).isTrue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"Hello")).isFalse();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)"metrics.reporter.dghttp.apikey")).isTrue();
    }
}

