/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class LimitedConnectionsFileSystemDelegationTest {
    @TempDir
    public File tempFolder;

    LimitedConnectionsFileSystemDelegationTest() {
    }

    @Test
    void testDelegateFsMethods() throws IOException {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs.open((Path)ArgumentMatchers.any(Path.class))).thenReturn(Mockito.mock(FSDataInputStream.class));
        Mockito.when((Object)fs.open((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyInt())).thenReturn(Mockito.mock(FSDataInputStream.class));
        Mockito.when((Object)fs.create((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyBoolean())).thenReturn(Mockito.mock(FSDataOutputStream.class));
        Mockito.when((Object)fs.create((Path)ArgumentMatchers.any(Path.class), (FileSystem.WriteMode)ArgumentMatchers.any(FileSystem.WriteMode.class))).thenReturn(Mockito.mock(FSDataOutputStream.class));
        Mockito.when((Object)fs.create((Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong())).thenReturn(Mockito.mock(FSDataOutputStream.class));
        LimitedConnectionsFileSystem lfs = new LimitedConnectionsFileSystem(fs, 1000);
        Random rnd = new Random();
        lfs.isDistributedFS();
        ((FileSystem)Mockito.verify((Object)fs)).isDistributedFS();
        lfs.getWorkingDirectory();
        ((FileSystem)Mockito.verify((Object)fs)).isDistributedFS();
        lfs.getHomeDirectory();
        ((FileSystem)Mockito.verify((Object)fs)).getHomeDirectory();
        lfs.getUri();
        ((FileSystem)Mockito.verify((Object)fs)).getUri();
        Path path = (Path)Mockito.mock(Path.class);
        lfs.getFileStatus(path);
        ((FileSystem)Mockito.verify((Object)fs)).getFileStatus(path);
        path = (FileStatus)Mockito.mock(FileStatus.class);
        int pos = rnd.nextInt();
        int len = rnd.nextInt();
        lfs.getFileBlockLocations((FileStatus)path, (long)pos, (long)len);
        ((FileSystem)Mockito.verify((Object)fs)).getFileBlockLocations((FileStatus)path, (long)pos, (long)len);
        path = (Path)Mockito.mock(Path.class);
        int bufferSize = rnd.nextInt();
        lfs.open(path, bufferSize);
        ((FileSystem)Mockito.verify((Object)fs)).open(path, bufferSize);
        path = (Path)Mockito.mock(Path.class);
        lfs.open(path);
        ((FileSystem)Mockito.verify((Object)fs)).open(path);
        lfs.getDefaultBlockSize();
        ((FileSystem)Mockito.verify((Object)fs)).getDefaultBlockSize();
        path = (Path)Mockito.mock(Path.class);
        lfs.listStatus(path);
        ((FileSystem)Mockito.verify((Object)fs)).listStatus(path);
        path = (Path)Mockito.mock(Path.class);
        lfs.exists(path);
        ((FileSystem)Mockito.verify((Object)fs)).exists(path);
        path = (Path)Mockito.mock(Path.class);
        boolean recursive = rnd.nextBoolean();
        lfs.delete(path, recursive);
        ((FileSystem)Mockito.verify((Object)fs)).delete(path, recursive);
        path = (Path)Mockito.mock(Path.class);
        lfs.mkdirs(path);
        ((FileSystem)Mockito.verify((Object)fs)).mkdirs(path);
        path = (Path)Mockito.mock(Path.class);
        boolean overwrite = rnd.nextBoolean();
        int bufferSize2 = rnd.nextInt();
        short replication = (short)rnd.nextInt();
        long blockSize = rnd.nextInt();
        lfs.create(path, overwrite, bufferSize2, replication, blockSize);
        ((FileSystem)Mockito.verify((Object)fs)).create(path, overwrite, bufferSize2, replication, blockSize);
        path = (Path)Mockito.mock(Path.class);
        FileSystem.WriteMode mode = rnd.nextBoolean() ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        lfs.create(path, mode);
        ((FileSystem)Mockito.verify((Object)fs)).create(path, mode);
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        lfs.rename(path1, path2);
        ((FileSystem)Mockito.verify((Object)fs)).rename(path1, path2);
        FileSystemKind kind = rnd.nextBoolean() ? FileSystemKind.FILE_SYSTEM : FileSystemKind.OBJECT_STORE;
        Mockito.when((Object)fs.getKind()).thenReturn((Object)kind);
        Assertions.assertThat((Comparable)lfs.getKind()).isEqualTo((Object)kind);
        ((FileSystem)Mockito.verify((Object)fs)).getKind();
    }

    @Test
    void testDelegateOutStreamMethods() throws IOException {
        FSDataOutputStream mockOut = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        long outPos = 46651L;
        Mockito.when((Object)mockOut.getPos()).thenReturn((Object)46651L);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs.create((Path)ArgumentMatchers.any(Path.class), (FileSystem.WriteMode)ArgumentMatchers.any(FileSystem.WriteMode.class))).thenReturn((Object)mockOut);
        LimitedConnectionsFileSystem lfs = new LimitedConnectionsFileSystem(fs, 100);
        FSDataOutputStream out = lfs.create((Path)Mockito.mock(Path.class), FileSystem.WriteMode.OVERWRITE);
        out.write(77);
        ((FSDataOutputStream)Mockito.verify((Object)mockOut)).write(77);
        byte[] bytes = new byte[1786];
        out.write(bytes, 100, 111);
        ((FSDataOutputStream)Mockito.verify((Object)mockOut)).write(bytes, 100, 111);
        Assertions.assertThat((long)out.getPos()).isEqualTo(46651L);
        out.flush();
        ((FSDataOutputStream)Mockito.verify((Object)mockOut)).flush();
        out.sync();
        ((FSDataOutputStream)Mockito.verify((Object)mockOut)).sync();
        out.close();
        ((FSDataOutputStream)Mockito.verify((Object)mockOut)).close();
    }

    @Test
    void testDelegateInStreamMethods() throws IOException {
        FSDataInputStream mockIn = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        int value = 93;
        int bytesRead = 11;
        long inPos = 93L;
        int available = 17;
        boolean markSupported = true;
        Mockito.when((Object)mockIn.read()).thenReturn((Object)93);
        Mockito.when((Object)mockIn.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)11);
        Mockito.when((Object)mockIn.getPos()).thenReturn((Object)93L);
        Mockito.when((Object)mockIn.available()).thenReturn((Object)17);
        Mockito.when((Object)mockIn.markSupported()).thenReturn((Object)true);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs.open((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)mockIn);
        LimitedConnectionsFileSystem lfs = new LimitedConnectionsFileSystem(fs, 100);
        FSDataInputStream in = lfs.open((Path)Mockito.mock(Path.class));
        Assertions.assertThat((int)in.read()).isEqualTo(93);
        Assertions.assertThat((int)in.read(new byte[11], 2, 5)).isEqualTo(11);
        Assertions.assertThat((long)in.getPos()).isEqualTo(93L);
        in.seek(17876L);
        ((FSDataInputStream)Mockito.verify((Object)mockIn)).seek(17876L);
        Assertions.assertThat((int)in.available()).isEqualTo(17);
        Assertions.assertThat((boolean)in.markSupported()).isEqualTo(true);
        in.mark(9876);
        ((FSDataInputStream)Mockito.verify((Object)mockIn)).mark(9876);
        in.close();
        ((FSDataInputStream)Mockito.verify((Object)mockIn)).close();
    }
}

