/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.apache.flink.core.fs.RefCountedBufferingFileStream;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RefCountedBufferingFileStreamTest {
    private static final int BUFFER_SIZE = 10;
    @TempDir
    private Path temporaryFolder;

    RefCountedBufferingFileStreamTest() {
    }

    @Test
    void testSmallWritesGoToBuffer() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(contentToWrite);
        Assertions.assertThat((int)stream.getPositionInBuffer()).isEqualTo(contentToWrite.length);
        Assertions.assertThat((long)stream.getPos()).isEqualTo((long)contentToWrite.length);
        stream.close();
        stream.release();
    }

    @Test
    void testExceptionWhenWritingToClosedFile() {
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> {
            RefCountedBufferingFileStream stream = this.getStreamToTest();
            byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
            stream.write(contentToWrite);
            Assertions.assertThat((int)stream.getPositionInBuffer()).isEqualTo(contentToWrite.length);
            Assertions.assertThat((long)stream.getPos()).isEqualTo((long)contentToWrite.length);
            stream.close();
            stream.write(contentToWrite);
        });
    }

    @Test
    void testBigWritesGoToFile() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello big world");
        stream.write(contentToWrite);
        Assertions.assertThat((int)stream.getPositionInBuffer()).isZero();
        Assertions.assertThat((long)stream.getPos()).isEqualTo((long)contentToWrite.length);
        stream.close();
        stream.release();
    }

    @Test
    void testSpillingWhenBufferGetsFull() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] firstContentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(firstContentToWrite);
        Assertions.assertThat((int)stream.getPositionInBuffer()).isEqualTo(firstContentToWrite.length);
        Assertions.assertThat((long)stream.getPos()).isEqualTo((long)firstContentToWrite.length);
        byte[] secondContentToWrite = RefCountedBufferingFileStreamTest.bytesOf(" world!");
        stream.write(secondContentToWrite);
        Assertions.assertThat((int)stream.getPositionInBuffer()).isEqualTo(secondContentToWrite.length);
        Assertions.assertThat((long)stream.getPos()).isEqualTo((long)(firstContentToWrite.length + secondContentToWrite.length));
        stream.close();
        stream.release();
    }

    @Test
    void testFlush() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(contentToWrite);
        Assertions.assertThat((int)stream.getPositionInBuffer()).isEqualTo(contentToWrite.length);
        Assertions.assertThat((long)stream.getPos()).isEqualTo((long)contentToWrite.length);
        stream.flush();
        Assertions.assertThat((int)stream.getPositionInBuffer()).isZero();
        Assertions.assertThat((long)stream.getPos()).isEqualTo((long)contentToWrite.length);
        byte[] contentRead = new byte[contentToWrite.length];
        new FileInputStream(stream.getInputFile()).read(contentRead, 0, contentRead.length);
        Assertions.assertThat((byte[])contentRead).isEqualTo((Object)contentToWrite);
        stream.release();
    }

    private RefCountedBufferingFileStream getStreamToTest() throws IOException {
        return new RefCountedBufferingFileStream(this.getRefCountedFileWithContent(), 10);
    }

    private RefCountedFileWithStream getRefCountedFileWithContent() throws IOException {
        File newFile = new File(TempDirUtils.newFolder((Path)this.temporaryFolder), ".tmp_" + UUID.randomUUID());
        OutputStream out = Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW);
        return RefCountedFileWithStream.newFile((File)newFile, (OutputStream)out);
    }

    private static byte[] bytesOf(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

