/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.util.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractRecoverableFsDataOutputStreamTest {
    @TempDir
    Path tmp;

    @Test
    void testDurableWriteOnCommit() throws IOException {
        int seed = 4711;
        Random random = new Random(4711L);
        byte[] buffer = new byte[16384];
        ArrayList<Event> testLog = new ArrayList<Event>();
        Path target = this.tmp.resolve("target");
        Path temp = this.tmp.resolve("temp");
        Tuple2<RecoverableFsDataOutputStream, Closeable> testInstance = this.createTestInstance(target, temp, testLog);
        RecoverableFsDataOutputStream testOutStreamInstance = (RecoverableFsDataOutputStream)testInstance.f0;
        random.nextBytes(buffer);
        testOutStreamInstance.write(buffer);
        Assertions.assertTrue((boolean)testLog.isEmpty());
        RecoverableFsDataOutputStream.Committer committer = testOutStreamInstance.closeForCommit();
        Assertions.assertEquals(this.getExpectedResult(), testLog);
        ((Closeable)testInstance.f1).close();
        Assertions.assertArrayEquals((byte[])buffer, (byte[])FileUtils.readAllBytes((Path)temp));
        Assertions.assertFalse((boolean)target.toFile().exists());
        committer.commit();
        Assertions.assertTrue((boolean)target.toFile().exists());
        Assertions.assertArrayEquals((byte[])buffer, (byte[])FileUtils.readAllBytes((Path)target));
    }

    public abstract Tuple2<RecoverableFsDataOutputStream, Closeable> createTestInstance(Path var1, Path var2, List<Event> var3) throws IOException;

    public List<Event> getExpectedResult() {
        return Arrays.asList(Event.FLUSH, Event.SYNC, Event.CLOSE);
    }

    public static enum Event {
        CLOSE,
        FLUSH,
        SYNC;

    }
}

