/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.function.ThrowingConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LocalFileSystemTest {
    @TempDir
    private static java.nio.file.Path tempFolder;

    LocalFileSystemTest() {
    }

    @Test
    void testLocalFilesystem() throws Exception {
        File tempdir = new File(TempDirUtils.newFolder((java.nio.file.Path)tempFolder), UUID.randomUUID().toString());
        File testfile1 = new File(tempdir, UUID.randomUUID().toString());
        File testfile2 = new File(tempdir, UUID.randomUUID().toString());
        Path pathtotestfile1 = new Path(testfile1.toURI().getPath());
        Path pathtotestfile2 = new Path(testfile2.toURI().getPath());
        LocalFileSystem lfs = new LocalFileSystem();
        Path pathtotmpdir = new Path(tempdir.toURI().getPath());
        Assertions.assertThat((boolean)lfs.exists(pathtotmpdir)).isFalse();
        Assertions.assertThat((boolean)tempdir.mkdirs()).isTrue();
        Assertions.assertThat((boolean)lfs.exists(pathtotmpdir)).isTrue();
        FileStatus localstatus1 = lfs.getFileStatus(pathtotmpdir);
        Assertions.assertThat((boolean)localstatus1.isDir()).isTrue();
        Object[] statusforfiles = lfs.listStatus(pathtotmpdir);
        Assertions.assertThat((Object[])statusforfiles).isEmpty();
        lfs.delete(pathtotmpdir, true);
        Assertions.assertThat((boolean)lfs.exists(pathtotmpdir)).isFalse();
        Assertions.assertThat((File)tempdir).doesNotExist();
        lfs.mkdirs(pathtotmpdir);
        Assertions.assertThat((File)tempdir).exists();
        FSDataOutputStream lfsoutput1 = lfs.create(pathtotestfile1, FileSystem.WriteMode.NO_OVERWRITE);
        Assertions.assertThat((boolean)testfile2.createNewFile()).isTrue();
        Assertions.assertThat((File)testfile1).exists();
        Assertions.assertThat((boolean)lfs.exists(pathtotestfile2)).isTrue();
        byte[] testbytes = new byte[]{1, 2, 3, 4, 5};
        lfsoutput1.write(testbytes);
        lfsoutput1.close();
        Assertions.assertThat((File)testfile1).hasSize(5L);
        byte[] testbytestest = new byte[5];
        try (FileInputStream fisfile1 = new FileInputStream(testfile1);){
            Assertions.assertThat((int)fisfile1.read(testbytestest)).isEqualTo(testbytestest.length);
        }
        Assertions.assertThat((byte[])testbytestest).containsExactly(testbytes);
        Assertions.assertThat((File)testfile1).hasSize(lfs.getFileStatus(pathtotestfile1).getLen());
        Assertions.assertThat((File)testfile1).hasSize(lfs.listStatus(pathtotestfile1)[0].getLen());
        FileOutputStream fosfile2 = new FileOutputStream(testfile2);
        fosfile2.write(testbytes);
        fosfile2.close();
        testbytestest = new byte[5];
        FSDataInputStream lfsinput2 = lfs.open(pathtotestfile2);
        Assertions.assertThat((int)lfsinput2.read(testbytestest)).isEqualTo(5);
        lfsinput2.close();
        Assertions.assertThat((byte[])testbytestest).containsExactly(testbytes);
        Assertions.assertThat((Object[])lfs.listStatus(pathtotmpdir)).hasSize(2);
        Assertions.assertThat((int)lfs.getFileBlockLocations(lfs.getFileStatus(pathtotestfile1), 0L, 0L).length).isOne();
        Assertions.assertThat((boolean)lfs.delete(pathtotestfile1, false)).isTrue();
        Assertions.assertThat((boolean)lfs.delete(pathtotmpdir, true)).isTrue();
        Assertions.assertThat((File)tempdir).doesNotExist();
    }

    @Test
    void testRenamePath() throws IOException {
        File rootDirectory = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        File srcDirectory = new File(new File(rootDirectory, "src"), "B");
        Assertions.assertThat((boolean)srcDirectory.mkdirs()).isTrue();
        File srcFile = new File(srcDirectory, "test.csv");
        Assertions.assertThat((boolean)srcFile.createNewFile()).isTrue();
        File destDirectory = new File(new File(rootDirectory, "dst"), "B");
        File destFile = new File(destDirectory, "test.csv");
        Path srcDirPath = new Path(srcDirectory.toURI());
        Path srcFilePath = new Path(srcFile.toURI());
        Path destDirPath = new Path(destDirectory.toURI());
        Path destFilePath = new Path(destFile.toURI());
        FileSystem fs = FileSystem.getLocalFileSystem();
        Assertions.assertThat((boolean)fs.exists(srcDirPath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(destDirPath)).isFalse();
        Assertions.assertThat((boolean)fs.rename(srcDirPath, destDirPath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(destFilePath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(srcDirPath)).isFalse();
        Assertions.assertThat((boolean)srcDirectory.mkdirs()).isTrue();
        Assertions.assertThat((boolean)srcFile.createNewFile()).isTrue();
        Assertions.assertThat((boolean)fs.rename(srcFilePath, destFilePath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(srcFilePath)).isFalse();
        Assertions.assertThat((boolean)fs.exists(srcDirPath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(destFilePath)).isTrue();
    }

    @Test
    void testRenameNonExistingFile() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File tmpDir = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        File srcFile = new File(tmpDir, "someFile.txt");
        File destFile = new File(tmpDir, "target");
        Path srcFilePath = new Path(srcFile.toURI());
        Path destFilePath = new Path(destFile.toURI());
        Assertions.assertThat((boolean)fs.rename(srcFilePath, destFilePath)).isFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Tag(value="FailsInGHAContainerWithRootUser")
    @Disabled
    void testRenameFileWithNoAccess() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File srcFile = TempDirUtils.newFile((java.nio.file.Path)tempFolder, (String)"someFile.txt");
        File destFile = new File(TempDirUtils.newFolder((java.nio.file.Path)tempFolder), "target");
        Assumptions.assumeThat((boolean)srcFile.getParentFile().setWritable(false, false)).isTrue();
        Assumptions.assumeThat((boolean)srcFile.setWritable(false, false)).isTrue();
        try {
            Path srcFilePath = new Path(srcFile.toURI());
            Path destFilePath = new Path(destFile.toURI());
            Assertions.assertThat((boolean)fs.rename(srcFilePath, destFilePath)).isFalse();
        }
        finally {
            srcFile.getParentFile().setWritable(true, false);
            srcFile.setWritable(true, false);
        }
    }

    @Test
    void testRenameToNonEmptyTargetDir() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File srcFolder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        File srcFile = new File(srcFolder, "someFile.txt");
        Assertions.assertThat((boolean)srcFile.createNewFile()).isTrue();
        File dstFolder = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        File dstFile = new File(dstFolder, "target");
        Assertions.assertThat((boolean)dstFile.createNewFile()).isTrue();
        Assertions.assertThat((boolean)fs.rename(new Path(srcFolder.toURI()), new Path(dstFolder.toURI()))).isFalse();
        Assertions.assertThat((boolean)dstFile.delete()).isTrue();
        Assertions.assertThat((boolean)fs.rename(new Path(srcFolder.toURI()), new Path(dstFolder.toURI()))).isTrue();
        Assertions.assertThat((File)new File(dstFolder, srcFile.getName())).exists();
    }

    @Test
    void testKind() {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Assertions.assertThat((Comparable)fs.getKind()).isEqualTo((Object)FileSystemKind.FILE_SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentMkdirs() throws Exception {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File root = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        int directoryDepth = 10;
        int concurrentOperations = 10;
        Collection<File> targetDirectories = this.createTargetDirectories(root, 10, 10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        try {
            ArrayList<CompletableFuture<Void>> mkdirsFutures = new ArrayList<CompletableFuture<Void>>(10);
            for (File targetDirectory : targetDirectories) {
                CompletableFuture<Void> mkdirsFuture = CompletableFuture.runAsync(() -> {
                    try {
                        cyclicBarrier.await();
                        Assertions.assertThat((boolean)fs.mkdirs(Path.fromLocalFile((File)targetDirectory))).isEqualTo(true);
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, executor);
                mkdirsFutures.add(mkdirsFuture);
            }
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(mkdirsFutures.toArray(new CompletableFuture[10]));
            allFutures.get();
            long timeout = 10000L;
        }
        catch (Throwable throwable) {
            long timeout = 10000L;
            ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCreatingFileInCurrentDirectoryWithRelativePath() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path filePath = new Path("local_fs_test_" + RandomStringUtils.randomAlphanumeric((int)16));
        try {
            FSDataOutputStream outputStream = fs.create(filePath, FileSystem.WriteMode.OVERWRITE);
            Throwable throwable = null;
            if (outputStream != null) {
                if (throwable != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    outputStream.close();
                }
            }
        }
        finally {
            for (int i = 0; i < 10 && fs.exists(filePath); ++i) {
                fs.delete(filePath, true);
            }
        }
    }

    @Test
    void testFlushMethodFailsOnClosedOutputStream() {
        AssertionsForClassTypes.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)FSDataOutputStream::flush)));
    }

    @Test
    void testWriteIntegerMethodFailsOnClosedOutputStream() {
        AssertionsForClassTypes.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(0))));
    }

    @Test
    void testWriteBytesMethodFailsOnClosedOutputStream() {
        AssertionsForClassTypes.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(new byte[0]))));
    }

    @Test
    void testWriteBytesSubArrayMethodFailsOnClosedOutputStream() {
        AssertionsForClassTypes.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(new byte[0], 0, 0))));
    }

    @Test
    void testGetPosMethodFailsOnClosedOutputStream() {
        AssertionsForClassTypes.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)FSDataOutputStream::getPos)));
    }

    private void testMethodCallFailureOnClosedStream(ThrowingConsumer<FSDataOutputStream, IOException> callback) throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        FSDataOutputStream outputStream = fs.create(new Path(tempFolder.toString(), "close_fs_test_" + UUID.randomUUID()), FileSystem.WriteMode.OVERWRITE);
        outputStream.close();
        callback.accept((Object)outputStream);
    }

    private Collection<File> createTargetDirectories(File root, int directoryDepth, int numberDirectories) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < directoryDepth; ++i) {
            stringBuilder.append('/').append(i);
        }
        ArrayList<File> targetDirectories = new ArrayList<File>(numberDirectories);
        for (int i = 0; i < numberDirectories; ++i) {
            targetDirectories.add(new File(root, stringBuilder.toString() + '/' + i));
        }
        return targetDirectories;
    }
}

