/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class ByteArrayInputStreamWithPosTest {
    private final byte[] data = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private final ByteArrayInputStreamWithPos stream = new ByteArrayInputStreamWithPos(this.data);

    ByteArrayInputStreamWithPosTest() {
    }

    @Test
    void testGetWithNullArray() {
        AssertionsForClassTypes.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.stream.read(null, 0, 1));
    }

    @Test
    void testGetWithNegativeLength() {
        int read = this.stream.read(new byte[0], 0, -1);
        Assertions.assertThat((int)read).isZero();
    }

    @Test
    void testGetWithTargetArrayOverflow() {
        AssertionsForClassTypes.assertThatExceptionOfType(IndexOutOfBoundsException.class).isThrownBy(() -> this.stream.read(new byte[0], 0, 2));
    }

    @Test
    void testGetWithEOF() {
        ByteArrayInputStreamWithPosTest.drainStream(this.stream);
        int read = this.stream.read(new byte[1], 0, 1);
        Assertions.assertThat((int)read).isEqualTo(-1);
    }

    @Test
    void testGetMoreThanAvailable() {
        int read = this.stream.read(new byte[20], 0, 20);
        Assertions.assertThat((int)read).isEqualTo(10);
        Assertions.assertThat((int)this.stream.read()).isEqualTo(-1);
    }

    @Test
    void testSetPosition() throws Exception {
        Assertions.assertThat((int)this.stream.available()).isEqualTo(this.data.length);
        Assertions.assertThat((int)this.stream.read()).isEqualTo(48);
        this.stream.setPosition(1);
        Assertions.assertThat((int)this.stream.available()).isEqualTo(this.data.length - 1);
        Assertions.assertThat((int)this.stream.read()).isEqualTo(49);
        this.stream.setPosition(3);
        Assertions.assertThat((int)this.stream.available()).isEqualTo(this.data.length - 3);
        Assertions.assertThat((int)this.stream.read()).isEqualTo(51);
        this.stream.setPosition(this.data.length);
        Assertions.assertThat((int)this.stream.available()).isZero();
        Assertions.assertThat((int)this.stream.read()).isEqualTo(-1);
    }

    @Test
    void testSetTooLargePosition() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.stream.setPosition(this.data.length + 1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Position out of bounds.");
    }

    @Test
    void testSetNegativePosition() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.stream.setPosition(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Position out of bounds.");
    }

    @Test
    void testSetBuffer() {
        ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos();
        Assertions.assertThat((int)in.read()).isEqualTo(-1);
        byte[] testData = new byte[]{66, 67, 68, 69};
        int off = 1;
        int len = 2;
        in.setBuffer(testData, off, len);
        for (int i = 0; i < len; ++i) {
            Assertions.assertThat((int)in.read()).isEqualTo((int)testData[i + off]);
        }
        Assertions.assertThat((int)in.read()).isEqualTo(-1);
    }

    private static int drainStream(ByteArrayInputStreamWithPos stream) {
        int skipped = 0;
        while (stream.read() != -1) {
            ++skipped;
        }
        return skipped;
    }
}

