/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.TestTemplate;

abstract class MemorySegmentTestBase {
    private final Random random = new Random();
    private int pageSize;

    MemorySegmentTestBase(int pageSize) {
        this.pageSize = pageSize;
    }

    void initMemorySegmentTestBase(int pageSize) {
        this.pageSize = pageSize;
    }

    abstract MemorySegment createSegment(int var1);

    abstract MemorySegment createSegment(int var1, Object var2);

    @TestTemplate
    void testByteAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.put(-1, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 < pageSize; ++i2) {
            segment.put(i2, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 < pageSize; ++i2) {
            Assertions.assertThat((byte)segment.get(i2)).isEqualTo((byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            segment.put(pos, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            Assertions.assertThat((byte)segment.get(pos)).isEqualTo((byte)this.random.nextInt());
        }
    }

    @TestTemplate
    void testBooleanAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(-1, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(pageSize, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(Integer.MAX_VALUE, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(Integer.MIN_VALUE, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 < pageSize; ++i2) {
            segment.putBoolean(i2, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 < pageSize; ++i2) {
            Assertions.assertThat((boolean)segment.getBoolean(i2)).isEqualTo(this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            segment.putBoolean(pos, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            Assertions.assertThat((boolean)segment.getBoolean(pos)).isEqualTo(this.random.nextBoolean());
        }
    }

    @TestTemplate
    void testCopyUnsafeIndexOutOfBounds(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        byte[] bytes = new byte[pageSize];
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.copyToUnsafe(1, (Object)bytes, 0, pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.copyFromUnsafe(1, (Object)bytes, 0, pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    void testEqualTo(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment seg1 = this.createSegment(pageSize);
        MemorySegment seg2 = this.createSegment(pageSize);
        byte[] referenceArray = new byte[pageSize];
        seg1.put(0, referenceArray);
        seg2.put(0, referenceArray);
        int i = new Random().nextInt(pageSize - 8);
        seg1.put(i, (byte)10);
        Assertions.assertThat((boolean)seg1.equalTo(seg2, i, i, 9)).isFalse();
        seg1.put(i, (byte)0);
        Assertions.assertThat((boolean)seg1.equalTo(seg2, i, i, 9)).isTrue();
        seg1.put(i + 8, (byte)10);
        Assertions.assertThat((boolean)seg1.equalTo(seg2, i, i, 9)).isFalse();
    }

    @TestTemplate
    void testCharAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putChar(-1, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(pageSize, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(Integer.MIN_VALUE, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(Integer.MAX_VALUE, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(0x7FFFFFFE, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(0x7FFFFFFE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 2; i2 += 2) {
            segment.putChar(i2, (char)this.random.nextInt(65535));
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 2; i2 += 2) {
            Assertions.assertThat((char)segment.getChar(i2)).isEqualTo((char)this.random.nextInt(65535));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            segment.putChar(pos, (char)this.random.nextInt(65535));
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            Assertions.assertThat((char)segment.getChar(pos)).isEqualTo((char)this.random.nextInt(65535));
        }
    }

    @TestTemplate
    void testShortAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putShort(-1, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(pageSize, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(Integer.MIN_VALUE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(Integer.MAX_VALUE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(0x7FFFFFFE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(0x7FFFFFFE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 2; i2 += 2) {
            segment.putShort(i2, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 2; i2 += 2) {
            Assertions.assertThat((short)segment.getShort(i2)).isEqualTo((short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            segment.putShort(pos, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            Assertions.assertThat((short)segment.getShort(pos)).isEqualTo((short)this.random.nextInt());
        }
    }

    @TestTemplate
    void testIntAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putInt(-1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(pageSize, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(pageSize - 3, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(Integer.MIN_VALUE, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(Integer.MAX_VALUE, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(0x7FFFFFFC, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(pageSize - 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(0x7FFFFFFC)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 4; i2 += 4) {
            segment.putInt(i2, this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 4; i2 += 4) {
            Assertions.assertThat((int)segment.getInt(i2)).isEqualTo(this.random.nextInt());
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            segment.putInt(pos, this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            Assertions.assertThat((int)segment.getInt(pos)).isEqualTo(this.random.nextInt());
        }
    }

    @TestTemplate
    void testLongAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putLong(-1, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(pageSize, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(pageSize - 7, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(Integer.MIN_VALUE, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(Integer.MAX_VALUE, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(0x7FFFFFF8, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(pageSize - 7)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(0x7FFFFFF8)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 8; i2 += 8) {
            segment.putLong(i2, this.random.nextLong());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 8; i2 += 8) {
            Assertions.assertThat((long)segment.getLong(i2)).isEqualTo(this.random.nextLong());
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            segment.putLong(pos, this.random.nextLong());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            Assertions.assertThat((long)segment.getLong(pos)).isEqualTo(this.random.nextLong());
        }
    }

    @TestTemplate
    void testFloatAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putFloat(-1, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(pageSize, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(pageSize - 3, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(Integer.MIN_VALUE, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(Integer.MAX_VALUE, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(0x7FFFFFFC, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(pageSize - 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(0x7FFFFFFC)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 4; i2 += 4) {
            segment.putFloat(i2, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 4; i2 += 4) {
            Assertions.assertThat((float)segment.getFloat(i2)).isCloseTo(this.random.nextFloat(), Assertions.within((Float)Float.valueOf(0.0f)));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            segment.putFloat(pos, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            Assertions.assertThat((float)segment.getFloat(pos)).isCloseTo(this.random.nextFloat(), Assertions.within((Float)Float.valueOf(0.0f)));
        }
    }

    @TestTemplate
    void testDoubleAccess(int pageSize) {
        int pos;
        int i;
        int i2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> segment.putDouble(-1, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(pageSize, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(pageSize - 7, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(Integer.MIN_VALUE, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(Integer.MAX_VALUE, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(0x7FFFFFF8, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(pageSize - 7)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(0x7FFFFFF8)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 8; i2 += 8) {
            segment.putDouble(i2, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= pageSize - 8; i2 += 8) {
            Assertions.assertThat((double)segment.getDouble(i2)).isCloseTo(this.random.nextDouble(), Assertions.within((Double)0.0));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            segment.putDouble(pos, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        occupied = new boolean[pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            Assertions.assertThat((double)segment.getDouble(pos)).isCloseTo(this.random.nextDouble(), Assertions.within((Double)0.0));
        }
    }

    @TestTemplate
    void testBulkBytePutExceptions(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        byte[] bytes = new byte[pageSize / 4 + pageSize % 4];
        this.random.nextBytes(bytes);
        Assertions.assertThatThrownBy(() -> segment.put(-1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-1, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize, bytes, 6, 44)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize - 5, bytes, 3, 6)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, bytes, 10, 20)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0x7FFFFFF4, bytes, 11, 11)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(3 * (pageSize / 4) + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(3 * (pageSize / 4) + 2, bytes, 0, bytes.length - 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(7 * (pageSize / 8) + 1, bytes, 0, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, -1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, -1, bytes.length + 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, Integer.MIN_VALUE, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, Integer.MAX_VALUE, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, Integer.MAX_VALUE - bytes.length + 1, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-2, bytes, -1, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    void testBulkByteGetExceptions(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        byte[] bytes = new byte[pageSize / 4];
        Assertions.assertThatThrownBy(() -> segment.put(-1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-1, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize, bytes, 6, 44)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(pageSize - 5, bytes, 3, 6)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, bytes, 10, 20)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0x7FFFFFF4, bytes, 11, 11)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(3 * (pageSize / 4) + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(3 * (pageSize / 4) + 2, bytes, 0, bytes.length - 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(7 * (pageSize / 8) + 1, bytes, 0, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, -1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, -1, bytes.length + 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, Integer.MIN_VALUE, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, Integer.MAX_VALUE, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, bytes, Integer.MAX_VALUE - bytes.length + 1, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-2, bytes, -1, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    void testBulkByteAccess(int pageSize) {
        int dataStartPos;
        byte[] data;
        int numBytes;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment segment = this.createSegment(pageSize);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        byte[] src = new byte[pageSize / 8];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(src);
            segment.put(i * (pageSize / 8), src);
        }
        this.random.setSeed(seed);
        byte[] expected = new byte[pageSize / 8];
        byte[] actual = new byte[pageSize / 8];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(expected);
            segment.get(i * (pageSize / 8), actual);
            Assertions.assertThat((byte[])actual).containsExactly(expected);
        }
        segment = this.createSegment(pageSize);
        byte[] expected2 = new byte[pageSize];
        this.random.nextBytes(expected2);
        for (int i = 0; i < 16; ++i) {
            segment.put(i * (pageSize / 16), expected2, i * (pageSize / 16), pageSize / 16);
        }
        byte[] actual2 = new byte[pageSize];
        for (int i = 0; i < 16; ++i) {
            segment.get(i * (pageSize / 16), actual2, i * (pageSize / 16), pageSize / 16);
        }
        Assertions.assertThat((byte[])actual2).containsExactly(expected2);
        segment = this.createSegment(pageSize);
        expected2 = new byte[pageSize];
        segment.put(0, expected2, 0, pageSize);
        for (int i = 0; i < 200; ++i) {
            numBytes = this.random.nextInt(pageSize - 10) + 1;
            int pos = this.random.nextInt(pageSize - numBytes + 1);
            data = new byte[(this.random.nextInt(3) + 1) * numBytes];
            dataStartPos = this.random.nextInt(data.length - numBytes + 1);
            this.random.nextBytes(data);
            System.arraycopy(data, dataStartPos, expected2, pos, numBytes);
            segment.put(pos, data, dataStartPos, numBytes);
        }
        byte[] validation = new byte[pageSize];
        segment.get(0, validation);
        Assertions.assertThat((byte[])validation).containsExactly(expected2);
        segment = this.createSegment(pageSize);
        byte[] contents = new byte[pageSize];
        this.random.nextBytes(contents);
        segment.put(0, contents);
        for (int i = 0; i < 200; ++i) {
            numBytes = this.random.nextInt(pageSize / 8) + 1;
            int pos = this.random.nextInt(pageSize - numBytes + 1);
            data = new byte[(this.random.nextInt(3) + 1) * numBytes];
            dataStartPos = this.random.nextInt(data.length - numBytes + 1);
            segment.get(pos, data, dataStartPos, numBytes);
            byte[] expected3 = Arrays.copyOfRange(contents, pos, pos + numBytes);
            byte[] validation2 = Arrays.copyOfRange(data, dataStartPos, dataStartPos + numBytes);
            Assertions.assertThat((byte[])validation2).containsExactly(expected3);
        }
    }

    @TestTemplate
    void testDataInputOutput(int pageSize) throws IOException {
        int len;
        int pos;
        int len2;
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment seg = this.createSegment(pageSize);
        byte[] contents = new byte[pageSize];
        this.random.nextBytes(contents);
        seg.put(0, contents);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(pageSize);
        DataOutputStream out = new DataOutputStream(buffer);
        for (pos = 0; pos < pageSize; pos += len2) {
            len2 = this.random.nextInt(200);
            len2 = Math.min(len2, pageSize - pos);
            seg.get((DataOutput)out, pos, len2);
        }
        byte[] result = buffer.toByteArray();
        Assertions.assertThat((byte[])result).containsExactly(contents);
        MemorySegment reader = this.createSegment(pageSize);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(result));
        for (pos = 0; pos < pageSize; pos += len) {
            len = this.random.nextInt(200);
            len = Math.min(len, pageSize - pos);
            reader.put((DataInput)in, pos, len);
        }
        byte[] targetBuffer = new byte[pageSize];
        reader.get(0, targetBuffer);
        Assertions.assertThat((byte[])targetBuffer).containsExactly(contents);
    }

    @TestTemplate
    void testDataInputOutputOutOfBounds(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        int segmentSize = 52;
        MemorySegment seg = this.createSegment(52);
        byte[] bytes = new byte[52];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        DataOutputStream out = new DataOutputStream(new ByteArrayOutputStream());
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, -1, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, 52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, -52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, Integer.MIN_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, Integer.MAX_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(new byte[52]));
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, -1, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, 52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, -52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, Integer.MIN_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, Integer.MAX_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    void testDataInputOutputStreamUnderflowOverflow(int pageSize) throws IOException {
        this.initMemorySegmentTestBase(pageSize);
        int segmentSize = 1337;
        MemorySegment seg = this.createSegment(1337);
        byte[] bytes = new byte[1337];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        DataOutputStream out = new DataOutputStream(new OutputStream(){
            int bytesSoFar = 0;

            @Override
            public void write(int b) throws IOException {
                ++this.bytesSoFar;
                if (this.bytesSoFar > 668) {
                    throw new IOException("overflow");
                }
            }
        });
        Assertions.assertThatThrownBy(() -> {
            int len;
            for (int pos = 0; pos < pageSize; pos += len) {
                len = this.random.nextInt(133);
                len = Math.min(len, pageSize - pos);
                seg.get((DataOutput)out, pos, len);
            }
        }).isInstanceOf(IOException.class);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(new byte[668]));
        Assertions.assertThatThrownBy(() -> {
            int len;
            for (int pos = 0; pos < pageSize; pos += len) {
                len = this.random.nextInt(133);
                len = Math.min(len, pageSize - pos);
                seg.put((DataInput)in, pos, len);
            }
        }).isInstanceOf(EOFException.class);
    }

    @TestTemplate
    void testByteBufferGet(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        this.testByteBufferGet(false);
        this.testByteBufferGet(true);
    }

    private void testByteBufferGet(boolean directBuffer) {
        int len;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        ByteBuffer target = directBuffer ? ByteBuffer.allocateDirect(3 * this.pageSize) : ByteBuffer.allocate(3 * this.pageSize);
        target.position(2 * this.pageSize);
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.get(pos, target, len);
        }
        byte[] result = new byte[this.pageSize];
        target.position(2 * this.pageSize);
        target.get(result);
        Assertions.assertThat((byte[])result).containsExactly(bytes);
    }

    @TestTemplate
    void testHeapByteBufferGetReadOnly(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        AssertionsForClassTypes.assertThatExceptionOfType(ReadOnlyBufferException.class).isThrownBy(() -> this.testByteBufferGetReadOnly(false));
    }

    @TestTemplate
    void testOffHeapByteBufferGetReadOnly(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        AssertionsForClassTypes.assertThatExceptionOfType(ReadOnlyBufferException.class).isThrownBy(() -> this.testByteBufferGetReadOnly(true));
    }

    private void testByteBufferGetReadOnly(boolean directBuffer) throws ReadOnlyBufferException {
        MemorySegment seg = this.createSegment(this.pageSize);
        ByteBuffer target = (directBuffer ? ByteBuffer.allocateDirect(this.pageSize) : ByteBuffer.allocate(this.pageSize)).asReadOnlyBuffer();
        seg.get(0, target, this.pageSize);
    }

    @TestTemplate
    void testByteBufferPut(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        this.testByteBufferPut(false);
        this.testByteBufferPut(true);
    }

    private void testByteBufferPut(boolean directBuffer) {
        int len;
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        ByteBuffer source = directBuffer ? ByteBuffer.allocateDirect(this.pageSize) : ByteBuffer.allocate(this.pageSize);
        source.put(bytes);
        source.clear();
        MemorySegment seg = this.createSegment(3 * this.pageSize);
        int offset = 2 * this.pageSize;
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.put(offset + pos, source, len);
        }
        byte[] result = new byte[this.pageSize];
        seg.get(offset, result);
        Assertions.assertThat((byte[])result).containsExactly(bytes);
    }

    @TestTemplate
    void testSlicedByteBufferGet(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        this.testSlicedByteBufferGet(false);
        this.testSlicedByteBufferGet(true);
    }

    private void testSlicedByteBufferGet(boolean directBuffer) {
        int len;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        ByteBuffer target = directBuffer ? ByteBuffer.allocateDirect(this.pageSize + 49) : ByteBuffer.allocate(this.pageSize + 49);
        target.position(19).limit(19 + this.pageSize);
        ByteBuffer slicedTarget = target.slice();
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.get(pos, slicedTarget, len);
        }
        byte[] result = new byte[this.pageSize];
        target.position(19);
        target.get(result);
        Assertions.assertThat((byte[])result).containsExactly(bytes);
    }

    @TestTemplate
    void testSlicedByteBufferPut(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        this.testSlicedByteBufferPut(false);
        this.testSlicedByteBufferPut(true);
    }

    private void testSlicedByteBufferPut(boolean directBuffer) {
        int len;
        byte[] bytes = new byte[this.pageSize + 49];
        this.random.nextBytes(bytes);
        ByteBuffer source = directBuffer ? ByteBuffer.allocateDirect(this.pageSize + 49) : ByteBuffer.allocate(this.pageSize + 49);
        source.put(bytes);
        source.position(19).limit(19 + this.pageSize);
        ByteBuffer slicedSource = source.slice();
        MemorySegment seg = this.createSegment(3 * this.pageSize);
        int offset = 2 * this.pageSize;
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.put(offset + pos, slicedSource, len);
        }
        byte[] result = new byte[this.pageSize];
        seg.get(offset, result);
        byte[] expected = Arrays.copyOfRange(bytes, 19, 19 + this.pageSize);
        Assertions.assertThat((byte[])result).containsExactly(expected);
    }

    @TestTemplate
    void testByteBufferOutOfBounds(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        int bbCapacity = pageSize / 10;
        int[] validOffsets = new int[]{0, 1, pageSize / 10 * 9};
        int[] invalidOffsets = new int[]{-1, pageSize + 1, -pageSize, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] validLengths = new int[]{0, 1, bbCapacity, pageSize};
        int[] invalidLengths = new int[]{-1, -pageSize, Integer.MAX_VALUE, Integer.MIN_VALUE};
        MemorySegment seg = this.createSegment(pageSize);
        for (ByteBuffer bb : new ByteBuffer[]{ByteBuffer.allocate(bbCapacity), ByteBuffer.allocateDirect(bbCapacity)}) {
            for (int off : validOffsets) {
                for (int len : invalidLengths) {
                    Assertions.assertThatThrownBy(() -> seg.put(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferUnderflowException.class});
                    Assertions.assertThatThrownBy(() -> seg.get(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferOverflowException.class});
                    Assertions.assertThat((int)bb.position()).isZero();
                    Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
                }
            }
            for (int off : invalidOffsets) {
                for (int len : validLengths) {
                    Assertions.assertThatThrownBy(() -> seg.put(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferUnderflowException.class});
                    Assertions.assertThatThrownBy(() -> seg.get(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferOverflowException.class});
                    Assertions.assertThat((int)bb.position()).isZero();
                    Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
                }
            }
            for (int off : validOffsets) {
                for (int len : validLengths) {
                    if (off + len <= pageSize) continue;
                    Assertions.assertThatThrownBy(() -> seg.put(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferUnderflowException.class});
                    Assertions.assertThatThrownBy(() -> seg.get(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferOverflowException.class});
                    Assertions.assertThat((int)bb.position()).isZero();
                    Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
                }
            }
        }
    }

    @TestTemplate
    void testByteBufferOverflowUnderflow(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        int bbCapacity = pageSize / 10;
        ByteBuffer bb = ByteBuffer.allocate(bbCapacity);
        MemorySegment seg = this.createSegment(pageSize);
        Assertions.assertThatThrownBy(() -> seg.get(pageSize / 5, bb, pageSize / 10 + 2)).isInstanceOf(BufferOverflowException.class);
        Assertions.assertThat((int)bb.position()).isZero();
        Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
        Assertions.assertThatThrownBy(() -> seg.put(pageSize / 5, bb, pageSize / 10 + 2)).isInstanceOf(BufferUnderflowException.class);
        Assertions.assertThat((int)bb.position()).isZero();
        Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
        int pos = bb.capacity() / 3;
        int limit = 2 * bb.capacity() / 3;
        bb.limit(limit);
        bb.position(pos);
        Assertions.assertThatThrownBy(() -> seg.get(20, bb, bb.capacity() / 3 + 3)).isInstanceOf(BufferOverflowException.class);
        Assertions.assertThat((int)bb.position()).isEqualTo(pos);
        Assertions.assertThat((int)bb.limit()).isEqualTo(limit);
        Assertions.assertThatThrownBy(() -> seg.put(20, bb, bb.capacity() / 3 + 3)).isInstanceOf(BufferUnderflowException.class);
        Assertions.assertThat((int)bb.position()).isEqualTo(pos);
        Assertions.assertThat((int)bb.limit()).isEqualTo(limit);
    }

    @TestTemplate
    void testCompareBytes(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        byte[] bytes1 = new byte[pageSize];
        byte[] bytes2 = new byte[pageSize];
        int stride = pageSize / 255;
        int shift = 16666;
        for (int i = 0; i < pageSize; ++i) {
            byte val;
            bytes1[i] = val = (byte)(i / stride & 0xFF);
            if (i + 16666 >= bytes2.length) continue;
            bytes2[i + 16666] = val;
        }
        MemorySegment seg1 = this.createSegment(pageSize);
        MemorySegment seg2 = this.createSegment(pageSize);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int i = 0; i < 1000; ++i) {
            int pos1 = this.random.nextInt(bytes1.length);
            int pos2 = this.random.nextInt(bytes2.length);
            int len = Math.min(Math.min(bytes1.length - pos1, bytes2.length - pos2), this.random.nextInt(pageSize / 50));
            int cmp = seg1.compare(seg2, pos1, pos2, len);
            if (pos1 < pos2 - 16666) {
                Assertions.assertThat((int)cmp).isLessThanOrEqualTo(0);
                continue;
            }
            Assertions.assertThat((int)cmp).isGreaterThanOrEqualTo(0);
        }
    }

    @TestTemplate
    void testCompareBytesWithDifferentLength(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        byte[] bytes1 = new byte[]{97, 98, 99};
        byte[] bytes2 = new byte[]{97, 98, 99, 100};
        MemorySegment seg1 = this.createSegment(4);
        MemorySegment seg2 = this.createSegment(4);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        Assertions.assertThat((int)seg1.compare(seg2, 0, 0, 3, 4)).isLessThan(0);
        Assertions.assertThat((int)seg1.compare(seg2, 0, 0, 3, 3)).isZero();
        Assertions.assertThat((int)seg1.compare(seg2, 0, 0, 3, 2)).isGreaterThan(0);
        Assertions.assertThat((int)seg1.compare(seg2, 1, 1, 2, 3)).isLessThan(0);
        Assertions.assertThat((int)seg1.compare(seg2, 1, 1, 2, 2)).isZero();
        Assertions.assertThat((int)seg1.compare(seg2, 1, 1, 2, 1)).isGreaterThan(0);
    }

    @TestTemplate
    void testSwapBytes(int pageSize) {
        int len;
        this.initMemorySegmentTestBase(pageSize);
        int halfPageSize = pageSize / 2;
        byte[] bytes1 = new byte[pageSize];
        byte[] bytes2 = new byte[halfPageSize];
        Arrays.fill(bytes2, (byte)1);
        MemorySegment seg1 = this.createSegment(pageSize);
        MemorySegment seg2 = this.createSegment(halfPageSize);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int pos = 0; pos < halfPageSize; pos += len) {
            len = this.random.nextInt(pageSize / 40);
            len = Math.min(len, halfPageSize - pos);
            seg1.swapBytes(new byte[len], seg2, pos + halfPageSize, pos, len);
        }
        for (int i = 0; i < halfPageSize; ++i) {
            Assertions.assertThat((byte)seg1.get(i)).isEqualTo((byte)0);
            Assertions.assertThat((byte)seg2.get(i)).isEqualTo((byte)0);
            Assertions.assertThat((byte)seg1.get(i + halfPageSize)).isEqualTo((byte)1);
        }
    }

    @TestTemplate
    void testCheckAgainstOverflowUnderflowOnRelease(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment seg = this.createSegment(512);
        seg.free();
        Assertions.assertThatThrownBy(() -> seg.get(0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> seg.get(Integer.MAX_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> seg.get(Integer.MIN_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> seg.getLong(0)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> seg.getLong(Integer.MAX_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
        Assertions.assertThatThrownBy(() -> seg.getLong(Integer.MIN_VALUE)).isInstanceOfAny(new Class[]{IllegalStateException.class, NullPointerException.class});
    }

    @TestTemplate
    void testByteBufferWrapping(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        MemorySegment seg = this.createSegment(1024);
        ByteBuffer buf1 = seg.wrap(13, 47);
        Assertions.assertThat((int)buf1.position()).isEqualTo(13);
        Assertions.assertThat((int)buf1.limit()).isEqualTo(60);
        Assertions.assertThat((int)buf1.remaining()).isEqualTo(47);
        ByteBuffer buf2 = seg.wrap(500, 267);
        Assertions.assertThat((int)buf2.position()).isEqualTo(500);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(767);
        Assertions.assertThat((int)buf2.remaining()).isEqualTo(267);
        ByteBuffer buf3 = seg.wrap(0, 1024);
        Assertions.assertThat((int)buf3.position()).isZero();
        Assertions.assertThat((int)buf3.limit()).isEqualTo(1024);
        Assertions.assertThat((int)buf3.remaining()).isEqualTo(1024);
        buf3.order(ByteOrder.LITTLE_ENDIAN);
        buf3.putInt(112, 651797651);
        Assertions.assertThat((int)seg.getIntLittleEndian(112)).isEqualTo(651797651);
        buf3.order(ByteOrder.BIG_ENDIAN);
        buf3.putInt(187, 992288337);
        Assertions.assertThat((int)seg.getIntBigEndian(187)).isEqualTo(992288337);
        Assertions.assertThatThrownBy(() -> seg.wrap(-1, 20)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, IllegalArgumentException.class});
        Assertions.assertThatThrownBy(() -> seg.wrap(10, -20)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, IllegalArgumentException.class});
        Assertions.assertThatThrownBy(() -> seg.wrap(10, 1024)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, IllegalArgumentException.class});
        seg.free();
        Assertions.assertThatThrownBy(() -> seg.wrap(13, 47)).isInstanceOfAny(new Class[]{IllegalStateException.class});
        buf3.order(ByteOrder.LITTLE_ENDIAN);
        buf3.putInt(112, 651797651);
        Assertions.assertThat((int)buf3.getInt(112)).isEqualTo(651797651);
        buf3.order(ByteOrder.BIG_ENDIAN);
        buf3.putInt(187, 992288337);
        Assertions.assertThat((int)buf3.getInt(187)).isEqualTo(992288337);
    }

    @TestTemplate
    void testOwner(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        Assertions.assertThat((Object)this.createSegment(64).getOwner()).isNull();
        Object theOwner = new Object();
        MemorySegment seg = this.createSegment(64, theOwner);
        Assertions.assertThat((Object)seg.getOwner()).isEqualTo(theOwner);
        seg.free();
        Assertions.assertThat((Object)seg.getOwner()).isNotNull();
    }

    @TestTemplate
    void testSizeAndFreeing(int pageSize) {
        this.initMemorySegmentTestBase(pageSize);
        int segmentSize = 651;
        MemorySegment seg = this.createSegment(651);
        Assertions.assertThat((int)seg.size()).isEqualTo(651);
        Assertions.assertThat((boolean)seg.isFreed()).isFalse();
        seg.free();
        Assertions.assertThat((boolean)seg.isFreed()).isTrue();
        Assertions.assertThat((int)seg.size()).isEqualTo(651);
    }

    @Parameters
    public static Collection<Object[]> executionModes() {
        return Arrays.asList({32768}, {4096}, {524288});
    }
}

