/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MemorySegmentUndersizedTest {
    MemorySegmentUndersizedTest() {
    }

    @Test
    void testZeroSizeHeapSegment() {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)0);
        MemorySegmentUndersizedTest.testZeroSizeBuffer(segment);
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(segment);
    }

    @Test
    void testZeroSizeOffHeapSegment() {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)0);
        MemorySegmentUndersizedTest.testZeroSizeBuffer(segment);
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(segment);
    }

    @Test
    void testZeroSizeOffHeapUnsafeSegment() {
        MemorySegment segment = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)0);
        MemorySegmentUndersizedTest.testZeroSizeBuffer(segment);
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(segment);
    }

    @Test
    void testSizeOneHeapSegment() {
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(MemorySegmentFactory.allocateUnpooledSegment((int)1));
    }

    @Test
    void testSizeOneOffHeapSegment() {
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)1));
    }

    @Test
    void testSizeOneOffHeapUnsafeSegment() {
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)1));
    }

    private static void testZeroSizeBuffer(MemorySegment segment) {
        Assertions.assertThatThrownBy(() -> segment.put(0, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(0, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(0)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    private static void testSegmentWithSizeLargerZero(MemorySegment segment) {
        Assertions.assertThatThrownBy(() -> segment.put(1, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-1, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(8, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-8, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(1, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(-1, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(8, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(-8, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(Integer.MAX_VALUE, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putBoolean(Integer.MIN_VALUE, true)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getBoolean(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(0, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(1, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(-1, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(8, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(-8, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(Integer.MAX_VALUE, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putChar(Integer.MIN_VALUE, 'a')).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getChar(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(0, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(1, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(-1, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(8, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(-8, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(Integer.MAX_VALUE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putShort(Integer.MIN_VALUE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getShort(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(0, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(-1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(8, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(-8, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(Integer.MAX_VALUE, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putInt(Integer.MIN_VALUE, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getInt(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(0, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(1, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(-1, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(8, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(-8, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(Integer.MAX_VALUE, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putLong(Integer.MIN_VALUE, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getLong(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(0, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(1, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(-1, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(8, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(-8, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(Integer.MAX_VALUE, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putFloat(Integer.MIN_VALUE, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getFloat(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(0, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(1, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(-1, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(8, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(Integer.MAX_VALUE, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.putDouble(Integer.MIN_VALUE, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(-8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.getDouble(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(0, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(1, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-1, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(8, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-8, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(0, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(1, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-1, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(8, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-8, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE, new byte[7])).isInstanceOf(IndexOutOfBoundsException.class);
        ByteBuffer buf = ByteBuffer.allocate(7);
        int numBytes = 3;
        Assertions.assertThatThrownBy(() -> segment.put(0, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(1, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-1, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(8, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(-8, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MAX_VALUE, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(Integer.MIN_VALUE, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(0, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(1, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-1, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(8, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(-8, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MAX_VALUE, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(Integer.MIN_VALUE, buf, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(new byte[20]));
        DataOutputStream dataOutput = new DataOutputStream(new ByteArrayOutputStream());
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, 0, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, 1, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, -1, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, 8, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, -8, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, Integer.MAX_VALUE, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.put(dataInput, Integer.MIN_VALUE, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, 0, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, 1, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, -1, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, 8, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, -8, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, Integer.MAX_VALUE, 3)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> segment.get(dataOutput, Integer.MIN_VALUE, 3)).isInstanceOf(IndexOutOfBoundsException.class);
    }
}

