/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class ShortType
implements SerializationTestType {
    private short value;

    public ShortType() {
        this.value = 0;
    }

    private ShortType(short value) {
        this.value = value;
    }

    @Override
    public ShortType getRandom(Random rnd) {
        return new ShortType((short)rnd.nextInt(65536));
    }

    @Override
    public int length() {
        return 2;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeShort((int)this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readShort();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortType) {
            ShortType other = (ShortType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

