/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.util.TraversableOnceException;
import org.apache.flink.util.UnionIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnionIteratorTest {
    UnionIteratorTest() {
    }

    @Test
    void testUnion() {
        UnionIterator iter = new UnionIterator();
        Assertions.assertThat((Iterator)iter.iterator()).isExhausted();
        iter.clear();
        Assertions.assertThatThrownBy(() -> {
            Integer cfr_ignored_0 = (Integer)iter.iterator().next();
        }).isInstanceOf(NoSuchElementException.class);
        iter.clear();
        iter.addList(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
        iter.addList(Collections.emptyList());
        iter.addList(Arrays.asList(8, 9, 10, 11));
        int val = 1;
        Iterator iterator = iter.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Assertions.assertThat((int)i).isEqualTo(val++);
        }
    }

    @Test
    void testTraversableOnce() {
        UnionIterator iter = new UnionIterator();
        iter.iterator();
        Assertions.assertThatThrownBy(() -> ((UnionIterator)iter).iterator()).isInstanceOf(TraversableOnceException.class);
        Assertions.assertThatThrownBy(() -> ((UnionIterator)iter).iterator()).isInstanceOf(TraversableOnceException.class);
        iter.clear();
        iter.iterator();
        Assertions.assertThatThrownBy(() -> ((UnionIterator)iter).iterator()).isInstanceOf(TraversableOnceException.class);
        Assertions.assertThatThrownBy(() -> ((UnionIterator)iter).iterator()).isInstanceOf(TraversableOnceException.class);
        iter.clear();
        iter.addList(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
        Iterator ints = iter.iterator();
        Assertions.assertThat((Integer)((Integer)ints.next())).isNotNull();
        Assertions.assertThat((Integer)((Integer)ints.next())).isNotNull();
        Assertions.assertThat((Integer)((Integer)ints.next())).isNotNull();
        Assertions.assertThatThrownBy(() -> ((UnionIterator)iter).iterator()).isInstanceOf(TraversableOnceException.class);
        iter.clear();
        Assertions.assertThat((Iterator)iter.iterator()).isExhausted();
    }
}

