/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleMaximum;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DoubleMaximumTest {
    DoubleMaximumTest() {
    }

    @Test
    void testGet() {
        DoubleMaximum max = new DoubleMaximum();
        Assertions.assertThat((Double)max.getLocalValue()).isCloseTo(Double.NEGATIVE_INFINITY, Assertions.within((Double)0.0));
    }

    @Test
    void testResetLocal() {
        DoubleMaximum max = new DoubleMaximum();
        double value = 13.57902468;
        max.add(value);
        Assertions.assertThat((Double)max.getLocalValue()).isCloseTo(value, Assertions.within((Double)0.0));
        max.resetLocal();
        Assertions.assertThat((Double)max.getLocalValue()).isCloseTo(Double.NEGATIVE_INFINITY, Assertions.within((Double)0.0));
    }

    @Test
    void testAdd() {
        DoubleMaximum max = new DoubleMaximum();
        max.add(1234.5768);
        max.add(9876.5432);
        max.add(-987.6543);
        max.add(-123.4567);
        Assertions.assertThat((Double)max.getLocalValue()).isCloseTo(9876.5432, Assertions.within((Double)0.0));
    }

    @Test
    void testMerge() {
        DoubleMaximum max1 = new DoubleMaximum();
        max1.add(1234.5768);
        DoubleMaximum max2 = new DoubleMaximum();
        max2.add(5678.9012);
        max2.merge((Accumulator)max1);
        Assertions.assertThat((Double)max2.getLocalValue()).isCloseTo(5678.9012, Assertions.within((Double)0.0));
        max1.merge((Accumulator)max2);
        Assertions.assertThat((Double)max1.getLocalValue()).isCloseTo(5678.9012, Assertions.within((Double)0.0));
    }

    @Test
    void testClone() {
        DoubleMaximum max = new DoubleMaximum();
        double value = 3.14159265359;
        max.add(value);
        DoubleMaximum clone = max.clone();
        Assertions.assertThat((Double)clone.getLocalValue()).isCloseTo(value, Assertions.within((Double)0.0));
    }
}

