/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.time.Duration;
import org.apache.flink.api.common.eventtime.BoundedOutOfOrdernessWatermarks;
import org.apache.flink.api.common.eventtime.TestingWatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BoundedOutOfOrdernessWatermarksTest {
    BoundedOutOfOrdernessWatermarksTest() {
    }

    @Test
    void testWatermarkBeforeRecords() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((Object)output.lastWatermark()).isNotNull();
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(Long.MIN_VALUE);
    }

    @Test
    void testWatermarkAfterEvent() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onEvent(new Object(), 1337L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(1326L);
    }

    @Test
    void testWatermarkAfterNonMonotonousEvents() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onEvent(new Object(), 12345L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12300L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12340L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12280L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(12334L);
    }

    @Test
    void testRepeatedProbe() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        BoundedOutOfOrdernessWatermarks watermarks = new BoundedOutOfOrdernessWatermarks(Duration.ofMillis(10L));
        watermarks.onEvent(new Object(), 723456L, (WatermarkOutput)new TestingWatermarkOutput());
        watermarks.onPeriodicEmit((WatermarkOutput)new TestingWatermarkOutput());
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assertions.assertThat((long)output.lastWatermark().getTimestamp()).isEqualTo(723445L);
    }
}

