/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MapOperatorTest
implements Serializable {
    MapOperatorTest() {
    }

    @Test
    void testMapPlain() throws Exception {
        MapFunction & Serializable parser = Integer::parseInt;
        MapOperatorBase op = new MapOperatorBase((MapFunction)parser, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), "TestMapper");
        ArrayList<String> input = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5", "6"));
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        List resultMutableSafe = op.executeOnCollections(input, null, executionConfig);
        executionConfig.enableObjectReuse();
        List resultRegular = op.executeOnCollections(input, null, executionConfig);
        Assertions.assertThat((List)resultMutableSafe).isEqualTo(Arrays.asList(1, 2, 3, 4, 5, 6));
        Assertions.assertThat((List)resultRegular).isEqualTo(Arrays.asList(1, 2, 3, 4, 5, 6));
    }

    @Test
    void testMapWithRuntimeContext() throws Exception {
        String taskName = "Test Task";
        final AtomicBoolean opened = new AtomicBoolean();
        final AtomicBoolean closed = new AtomicBoolean();
        RichMapFunction<String, Integer> parser = new RichMapFunction<String, Integer>(){

            public void open(OpenContext openContext) {
                opened.set(true);
                RuntimeContext ctx = this.getRuntimeContext();
                Assertions.assertThat((int)ctx.getTaskInfo().getIndexOfThisSubtask()).isZero();
                Assertions.assertThat((int)ctx.getTaskInfo().getNumberOfParallelSubtasks()).isOne();
                Assertions.assertThat((String)ctx.getTaskInfo().getTaskName()).isEqualTo("Test Task");
            }

            public Integer map(String value) {
                return Integer.parseInt(value);
            }

            public void close() {
                closed.set(true);
            }
        };
        MapOperatorBase op = new MapOperatorBase((MapFunction)parser, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), "Test Task");
        ArrayList<String> input = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5", "6"));
        HashMap accumulatorMap = new HashMap();
        HashMap cpTasks = new HashMap();
        TaskInfoImpl taskInfo = new TaskInfoImpl("Test Task", 1, 0, 1, 0);
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableObjectReuse();
        List resultMutableSafe = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        executionConfig.enableObjectReuse();
        List resultRegular = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        Assertions.assertThat((List)resultMutableSafe).isEqualTo(Arrays.asList(1, 2, 3, 4, 5, 6));
        Assertions.assertThat((List)resultRegular).isEqualTo(Arrays.asList(1, 2, 3, 4, 5, 6));
        Assertions.assertThat((AtomicBoolean)opened).isTrue();
        Assertions.assertThat((AtomicBoolean)closed).isTrue();
    }
}

