/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.resources;

import java.math.BigDecimal;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.api.common.resources.TestResource;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.Test;

class ResourceTest {
    ResourceTest() {
    }

    @Test
    void testConstructorValid() {
        TestResource v1 = new TestResource(0.1);
        ResourceTest.assertTestResourceValueEquals(0.1, v1);
        TestResource v2 = new TestResource(BigDecimal.valueOf(0.1));
        ResourceTest.assertTestResourceValueEquals(0.1, v2);
    }

    @Test
    void testConstructorInvalidValue() {
        Assertions.assertThatThrownBy(() -> new TestResource(-0.1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testEquals() {
        TestResource v1 = new TestResource(0.1);
        TestResource v2 = new TestResource(0.1);
        TestResource v3 = new TestResource(0.2);
        Assertions.assertThat((Comparable)((Object)v2)).isEqualTo((Object)v1);
        Assertions.assertThat((Comparable)((Object)v3)).isNotEqualTo((Object)v1);
    }

    @Test
    void testEqualsIgnoringScale() {
        TestResource v1 = new TestResource(new BigDecimal("0.1"));
        TestResource v2 = new TestResource(new BigDecimal("0.10"));
        Assertions.assertThat((Comparable)((Object)v2)).isEqualTo((Object)v1);
    }

    @Test
    void testHashCodeIgnoringScale() {
        TestResource v1 = new TestResource(new BigDecimal("0.1"));
        TestResource v2 = new TestResource(new BigDecimal("0.10"));
        Assertions.assertThat((Comparable)((Object)v2)).hasSameHashCodeAs((Object)v1);
    }

    @Test
    void testMerge() {
        TestResource v1 = new TestResource(0.1);
        TestResource v2 = new TestResource(0.2);
        ResourceTest.assertTestResourceValueEquals(0.3, v1.merge(v2));
    }

    @Test
    void testMergeErrorOnDifferentTypes() {
        TestResource v1 = new TestResource(0.1);
        CPUResource v2 = new CPUResource(0.1);
        Assertions.assertThatThrownBy(() -> ResourceTest.lambda$testMergeErrorOnDifferentTypes$1(v1, (Resource)v2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSubtract() {
        TestResource v1 = new TestResource(0.2);
        TestResource v2 = new TestResource(0.1);
        ResourceTest.assertTestResourceValueEquals(0.1, v1.subtract(v2));
    }

    @Test
    void testSubtractLargerValue() {
        TestResource v1 = new TestResource(0.1);
        TestResource v2 = new TestResource(0.2);
        Assertions.assertThatThrownBy(() -> v1.subtract(v2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSubtractErrorOnDifferentTypes() {
        TestResource v1 = new TestResource(0.1);
        CPUResource v2 = new CPUResource(0.1);
        Assertions.assertThatThrownBy(() -> ResourceTest.lambda$testSubtractErrorOnDifferentTypes$3(v1, (Resource)v2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDivide() {
        TestResource resource = new TestResource(0.04);
        BigDecimal by = BigDecimal.valueOf(0.1);
        ResourceTest.assertTestResourceValueEquals(0.4, resource.divide(by));
    }

    @Test
    void testDivideNegative() {
        TestResource resource = new TestResource(1.2);
        BigDecimal by = BigDecimal.valueOf(-0.5);
        Assertions.assertThatThrownBy(() -> resource.divide(by)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDivideInteger() {
        TestResource resource = new TestResource(0.12);
        int by = 4;
        ResourceTest.assertTestResourceValueEquals(0.03, resource.divide(4));
    }

    @Test
    void testDivideNegativeInteger() {
        TestResource resource = new TestResource(1.2);
        int by = -5;
        Assertions.assertThatThrownBy(() -> resource.divide(-5)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testMultiply() {
        TestResource resource = new TestResource(0.3);
        BigDecimal by = BigDecimal.valueOf(0.2);
        ResourceTest.assertTestResourceValueEquals(0.06, resource.multiply(by));
    }

    @Test
    void testMutiplyNegative() {
        TestResource resource = new TestResource(0.3);
        BigDecimal by = BigDecimal.valueOf(-0.2);
        Assertions.assertThatThrownBy(() -> resource.multiply(by)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testMultiplyInteger() {
        TestResource resource = new TestResource(0.3);
        int by = 2;
        ResourceTest.assertTestResourceValueEquals(0.6, resource.multiply(2));
    }

    @Test
    void testMutiplyNegativeInteger() {
        TestResource resource = new TestResource(0.3);
        int by = -2;
        Assertions.assertThatThrownBy(() -> resource.multiply(-2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testIsZero() {
        TestResource resource1 = new TestResource(0.0);
        TestResource resource2 = new TestResource(1.0);
        Assertions.assertThat((boolean)resource1.isZero()).isTrue();
        Assertions.assertThat((boolean)resource2.isZero()).isFalse();
    }

    @Test
    void testCompareTo() {
        TestResource resource1 = new TestResource(0.0);
        TestResource resource2 = new TestResource(0.0);
        TestResource resource3 = new TestResource(1.0);
        AssertionsForInterfaceTypes.assertThatComparable((Comparable)((Object)resource1)).isEqualByComparingTo((Object)resource1);
        AssertionsForInterfaceTypes.assertThatComparable((Comparable)((Object)resource2)).isEqualByComparingTo((Object)resource1);
        AssertionsForInterfaceTypes.assertThatComparable((Comparable)((Object)resource1)).isLessThan((Object)resource3);
        AssertionsForInterfaceTypes.assertThatComparable((Comparable)((Object)resource3)).isGreaterThan((Object)resource1);
    }

    @Test
    void testCompareToFailNull() {
        Assertions.assertThatThrownBy(() -> new TestResource(0.0).compareTo(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testCompareToFailDifferentType() {
        TestResource resource1 = new TestResource(0.0){};
        TestResource resource2 = new TestResource(0.0){};
        Assertions.assertThatThrownBy(() -> resource1.compareTo(resource2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testCompareToFailDifferentName() {
        TestResource resource1 = new TestResource("name1", 0.0);
        TestResource resource2 = new TestResource("name2", 0.0);
        Assertions.assertThatThrownBy(() -> resource1.compareTo(resource2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValueScaleLimited() {
        TestResource v1 = new TestResource(0.100000001);
        ResourceTest.assertTestResourceValueEquals(0.1, v1);
        Resource v2 = new TestResource(1.0).divide(3);
        ResourceTest.assertTestResourceValueEquals(0.33333333, v2);
    }

    @Test
    void testStripTrailingZeros() {
        Resource v = new TestResource(0.25).multiply(2);
        Assertions.assertThat((String)v.getValue().toString()).isEqualTo("0.5");
    }

    private static void assertTestResourceValueEquals(double value, Resource resource) {
        Assertions.assertThat((Comparable)resource).isEqualTo((Object)new TestResource(value));
    }

    private static /* synthetic */ void lambda$testSubtractErrorOnDifferentTypes$3(Resource v1, Resource v2) throws Throwable {
        v1.subtract(v2);
    }

    private static /* synthetic */ void lambda$testMergeErrorOnDifferentTypes$1(Resource v1, Resource v2) throws Throwable {
        v1.merge(v2);
    }
}

