/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.StateDeclarations;
import org.apache.flink.api.common.state.ValueStateDeclaration;
import org.apache.flink.api.common.typeinfo.TypeDescriptor;
import org.apache.flink.api.common.typeinfo.TypeDescriptors;
import org.apache.flink.types.BooleanValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class ValueStateDeclarationTest {
    private static TypeDescriptor<BooleanValue> booleanValueDescriptor;
    private static ValueStateDeclaration<BooleanValue> valueStateDeclaration;

    ValueStateDeclarationTest() {
    }

    @BeforeAll
    static void setUp() throws ReflectiveOperationException {
        booleanValueDescriptor = TypeDescriptors.value((TypeDescriptor & Serializable)() -> BooleanValue.class);
        valueStateDeclaration = StateDeclarations.valueState((String)"valueState", booleanValueDescriptor);
    }

    @Test
    void testValueStateDeclarationName() {
        Assertions.assertThat((String)valueStateDeclaration.getName()).isEqualTo("valueState");
    }

    @Test
    void testValueStateDeclarationDistribution() {
        Assertions.assertThat((Comparable)valueStateDeclaration.getRedistributionMode()).isEqualTo((Object)StateDeclaration.RedistributionMode.NONE);
    }

    @Test
    void testValueStateDeclarationType() {
        Assertions.assertThat((Object)valueStateDeclaration.getTypeDescriptor()).isEqualTo(booleanValueDescriptor);
    }
}

