/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeSerializer;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.junit.jupiter.api.Test;

class CompositeSerializerTest {
    private static final SerializerConfigImpl serializerConf = new SerializerConfigImpl();
    private static final List<Tuple2<TypeSerializer<?>, Object[]>> TEST_FIELD_SERIALIZERS = Arrays.asList(Tuple2.of((Object)BooleanSerializer.INSTANCE, (Object)new Object[]{true, false}), Tuple2.of((Object)LongSerializer.INSTANCE, (Object)new Object[]{1L, 23L}), Tuple2.of((Object)StringSerializer.INSTANCE, (Object)new Object[]{"teststr1", "teststr2"}), Tuple2.of((Object)TypeInformation.of(Pojo.class).createSerializer((SerializerConfig)serializerConf), (Object)new Object[]{new Pojo(3, new String[]{"123", "456"}), new Pojo(6, new String[0])}));

    CompositeSerializerTest() {
    }

    @Test
    void testSingleFieldSerializer() {
        TEST_FIELD_SERIALIZERS.forEach(t -> {
            TypeSerializer[] fieldSerializers = new TypeSerializer[]{(TypeSerializer)t.f0};
            List[] instances = (List[])Arrays.stream((Object[])t.f1).map(xva$0 -> Arrays.asList(xva$0)).toArray(List[]::new);
            this.runTests(((TypeSerializer)t.f0).getLength(), fieldSerializers, instances);
        });
    }

    @Test
    void testPairFieldSerializer() {
        TEST_FIELD_SERIALIZERS.forEach(t1 -> TEST_FIELD_SERIALIZERS.forEach(t2 -> {
            TypeSerializer[] fieldSerializers = new TypeSerializer[]{(TypeSerializer)t1.f0, (TypeSerializer)t2.f0};
            List[] instances = (List[])IntStream.range(0, ((Object[])t1.f1).length).mapToObj(i -> Arrays.asList(((Object[])t1.f1)[i], ((Object[])t2.f1)[i])).toArray(List[]::new);
            this.runTests(CompositeSerializerTest.getLength(fieldSerializers), fieldSerializers, instances);
        }));
    }

    @Test
    void testAllFieldSerializer() {
        TypeSerializer[] fieldSerializers = (TypeSerializer[])TEST_FIELD_SERIALIZERS.stream().map(t -> (TypeSerializer)t.f0).toArray(TypeSerializer[]::new);
        List[] instances = (List[])IntStream.range(0, ((Object[])CompositeSerializerTest.TEST_FIELD_SERIALIZERS.get((int)0).f1).length).mapToObj(CompositeSerializerTest::getTestCase).toArray(List[]::new);
        this.runTests(CompositeSerializerTest.getLength(fieldSerializers), fieldSerializers, instances);
    }

    private static List<Object> getTestCase(int index) {
        return Arrays.asList(TEST_FIELD_SERIALIZERS.stream().map(t -> ((Object[])t.f1)[index]).toArray(Object[]::new));
    }

    private static int getLength(TypeSerializer<Object>[] fieldSerializers) {
        return Arrays.stream(fieldSerializers).allMatch(fs -> fs.getLength() > 0) ? Arrays.stream(fieldSerializers).mapToInt(TypeSerializer::getLength).sum() : -1;
    }

    private void runTests(int length, TypeSerializer<Object>[] fieldSerializers, List<Object> ... instances) {
        for (boolean immutability : Arrays.asList(true, false)) {
            TestListCompositeSerializer serializer = new TestListCompositeSerializer(immutability, fieldSerializers);
            CompositeSerializerTestInstance test = new CompositeSerializerTestInstance((TypeSerializer<List<Object>>)serializer, length, instances);
            test.testAll();
        }
    }

    private static class CompositeSerializerTestInstance
    extends SerializerTestInstance<List<Object>> {
        CompositeSerializerTestInstance(TypeSerializer<List<Object>> serializer, int length, List<Object> ... testData) {
            super(serializer, CompositeSerializerTestInstance.getCls(testData[0]), length, testData);
        }

        private static Class<List<Object>> getCls(List<Object> instance) {
            return TypeExtractor.getForObject(instance).getTypeClass();
        }
    }

    public static class TestListCompositeSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<List<Object>, TestListCompositeSerializer> {
        private boolean isImmutableTargetType;

        public TestListCompositeSerializerSnapshot() {
            this.isImmutableTargetType = false;
        }

        public TestListCompositeSerializerSnapshot(TestListCompositeSerializer serializerInstance, boolean isImmutableTargetType) {
            super((TypeSerializer)serializerInstance);
            this.isImmutableTargetType = isImmutableTargetType;
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 0;
        }

        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            out.writeBoolean(this.isImmutableTargetType);
        }

        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.isImmutableTargetType = in.readBoolean();
        }

        protected TypeSerializer<?>[] getNestedSerializers(TestListCompositeSerializer outerSerializer) {
            return outerSerializer.fieldSerializers;
        }

        protected TestListCompositeSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new TestListCompositeSerializer(this.isImmutableTargetType, nestedSerializers);
        }
    }

    private static class TestListCompositeSerializer
    extends CompositeSerializer<List<Object>> {
        TestListCompositeSerializer(boolean isImmutableTargetType, TypeSerializer<?> ... fieldSerializers) {
            super(isImmutableTargetType, fieldSerializers);
        }

        TestListCompositeSerializer(CompositeSerializer.PrecomputedParameters precomputed, TypeSerializer<?> ... fieldSerializers) {
            super(precomputed, fieldSerializers);
        }

        public List<Object> createInstance(Object ... values) {
            return Arrays.asList(values);
        }

        protected void setField(@Nonnull List<Object> value, int index, Object fieldValue) {
            if (this.precomputed.immutable) {
                throw new UnsupportedOperationException("Type is immutable");
            }
            value.set(index, fieldValue);
        }

        protected Object getField(@Nonnull List<Object> value, int index) {
            return value.get(index);
        }

        protected CompositeSerializer<List<Object>> createSerializerInstance(CompositeSerializer.PrecomputedParameters precomputed, TypeSerializer<?> ... originalSerializers) {
            return new TestListCompositeSerializer(precomputed, originalSerializers);
        }

        public TypeSerializerSnapshot<List<Object>> snapshotConfiguration() {
            return new TestListCompositeSerializerSnapshot(this, this.precomputed.immutableTargetType);
        }
    }

    private static class Pojo {
        public final int f1;
        public final String[] f2;

        private Pojo(int f1, String[] f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            return this.f1 == pojo.f1 && Arrays.equals(this.f2, pojo.f2);
        }

        public int hashCode() {
            int result = Objects.hash(this.f1);
            result = 31 * result + Arrays.hashCode(this.f2);
            return result;
        }

        public String toString() {
            return "Pojo{f1=" + this.f1 + ", f2=" + Arrays.toString(this.f2) + "}";
        }
    }
}

