/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.testutils.migration.SchemaCompatibilityTestingSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompositeTypeSerializerUtilTest {
    CompositeTypeSerializerUtilTest() {
    }

    @Test
    void testCompatibleAsIsIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer("first serializer").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("second serializer").snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("first serializer"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("second serializer")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Assertions.assertThat((boolean)intermediateCompatibilityResult.isCompatibleAsIs()).isTrue();
        Assertions.assertThat((boolean)intermediateCompatibilityResult.getFinalResult().isCompatibleAsIs()).isTrue();
        Assertions.assertThat((Object[])intermediateCompatibilityResult.getNestedSerializers()).containsExactly((Object[])((TypeSerializer[])Arrays.stream(newSerializerSnapshots).map(TypeSerializerSnapshot::restoreSerializer).toArray(TypeSerializer[]::new)));
    }

    @Test
    void testCompatibleWithReconfiguredSerializerIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer("a").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("b").snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("a"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration("b")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Object[] expectedReconfiguredNestedSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer("a"), new SchemaCompatibilityTestingSerializer("b")};
        Assertions.assertThat((boolean)intermediateCompatibilityResult.isCompatibleWithReconfiguredSerializer()).isTrue();
        Assertions.assertThat((Object[])intermediateCompatibilityResult.getNestedSerializers()).containsExactly(expectedReconfiguredNestedSerializers);
    }

    @Test
    void testCompatibleAfterMigrationIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer("a").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("b").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("c").snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration("a"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterMigration("b"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("c")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Assertions.assertThat((boolean)intermediateCompatibilityResult.isCompatibleAfterMigration()).isTrue();
        Assertions.assertThat((boolean)intermediateCompatibilityResult.getFinalResult().isCompatibleAfterMigration()).isTrue();
    }

    @Test
    void testIncompatibleIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer().snapshotConfiguration(), new SchemaCompatibilityTestingSerializer().snapshotConfiguration(), new SchemaCompatibilityTestingSerializer().snapshotConfiguration(), new SchemaCompatibilityTestingSerializer().snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsIncompatibleWithTheLastSerializer(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterMigration()};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Assertions.assertThat((boolean)intermediateCompatibilityResult.isIncompatible()).isTrue();
        Assertions.assertThat((boolean)intermediateCompatibilityResult.getFinalResult().isIncompatible()).isTrue();
    }

    @Test
    void testGetFinalResultOnUndefinedReconfigureIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.undefinedReconfigureResult((TypeSerializer[])new TypeSerializer[]{IntSerializer.INSTANCE});
        Assertions.assertThatThrownBy(() -> ((CompositeTypeSerializerUtil.IntermediateCompatibilityResult)intermediateCompatibilityResult).getFinalResult()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testGetNestedSerializersOnCompatibleAfterMigrationIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.definedCompatibleAfterMigrationResult();
        Assertions.assertThatThrownBy(() -> ((CompositeTypeSerializerUtil.IntermediateCompatibilityResult)intermediateCompatibilityResult).getNestedSerializers()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testGetNestedSerializersOnIncompatibleIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.definedIncompatibleResult();
        Assertions.assertThatThrownBy(() -> ((CompositeTypeSerializerUtil.IntermediateCompatibilityResult)intermediateCompatibilityResult).getNestedSerializers()).isInstanceOf(IllegalStateException.class);
    }
}

