/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class EnumSerializerCompatibilityTest {
    @TempDir
    private static Path tempDir;
    private static final String ENUM_NAME = "EnumSerializerUpgradeTestEnum";
    private static final String ENUM_A = "public enum EnumSerializerUpgradeTestEnum { A, B, C }";
    private static final String ENUM_B = "public enum EnumSerializerUpgradeTestEnum { A, B, C, D }";
    private static final String ENUM_C = "public enum EnumSerializerUpgradeTestEnum { A, C }";
    private static final String ENUM_D = "public enum EnumSerializerUpgradeTestEnum { A, C, B }";

    EnumSerializerCompatibilityTest() {
    }

    @Test
    void checkIndenticalEnums() throws Exception {
        Assertions.assertThat((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_A).isCompatibleAsIs()).isTrue();
    }

    @Test
    void checkAppendedField() throws Exception {
        Assertions.assertThat((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_B).isCompatibleWithReconfiguredSerializer()).isTrue();
    }

    @Test
    void removingFieldShouldBeIncompatible() throws Exception {
        Assertions.assertThatThrownBy(() -> EnumSerializerCompatibilityTest.checkCompatibility(ENUM_B, ENUM_A)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void checkDifferentFieldOrder() throws Exception {
        Assertions.assertThat((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_D).isCompatibleWithReconfiguredSerializer()).isTrue();
    }

    private static TypeSerializerSchemaCompatibility checkCompatibility(String enumSourceA, String enumSourceB) throws IOException, ClassNotFoundException {
        TypeSerializerSnapshot restoredSnapshot;
        byte[] snapshotBytes;
        URLClassLoader classLoader = ClassLoaderUtils.compileAndLoadJava(TempDirUtils.newFolder((Path)tempDir), "EnumSerializerUpgradeTestEnum.java", enumSourceA);
        EnumSerializer enumSerializer = new EnumSerializer(classLoader.loadClass(ENUM_NAME));
        EnumSerializer.EnumSerializerSnapshot snapshot = enumSerializer.snapshotConfiguration();
        try (ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
             DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper((OutputStream)outBuffer);){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)outputViewStreamWrapper, (TypeSerializerSnapshot)snapshot);
            snapshotBytes = outBuffer.toByteArray();
        }
        URLClassLoader classLoader2 = ClassLoaderUtils.compileAndLoadJava(TempDirUtils.newFolder((Path)tempDir), "EnumSerializerUpgradeTestEnum.java", enumSourceB);
        try (ByteArrayInputStream inBuffer = new ByteArrayInputStream(snapshotBytes);
             DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inBuffer);){
            restoredSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)inputViewStreamWrapper, (ClassLoader)classLoader2);
        }
        EnumSerializer enumSerializer2 = new EnumSerializer(classLoader2.loadClass(ENUM_NAME));
        return enumSerializer2.snapshotConfiguration().resolveSchemaCompatibility(restoredSnapshot);
    }
}

