/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;

class RowComparatorWithManyFieldsTests
extends ComparatorTestBase<Row> {
    private static final int numberOfFields = 10;
    private static RowTypeInfo typeInfo;
    private static final Row[] data;

    RowComparatorWithManyFieldsTests() {
    }

    @BeforeAll
    static void setUp() throws Exception {
        TypeInformation[] fieldTypes = new TypeInformation[10];
        for (int i = 0; i < 10; ++i) {
            fieldTypes[i] = BasicTypeInfo.STRING_TYPE_INFO;
        }
        typeInfo = new RowTypeInfo(fieldTypes);
    }

    @Override
    protected void deepEquals(String message, Row should, Row is) {
        int arity = should.getArity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)is.getArity()).as(message, new Object[0])).isEqualTo(arity);
        for (int i = 0; i < arity; ++i) {
            Object copiedValue = should.getField(i);
            Object element = is.getField(i);
            ((ObjectAssert)Assertions.assertThat((Object)element).as(message, new Object[0])).isEqualTo(copiedValue);
        }
    }

    @Override
    protected TypeComparator<Row> createComparator(boolean ascending) {
        return typeInfo.createComparator(new int[]{0}, new boolean[]{ascending}, 0, new ExecutionConfig());
    }

    @Override
    protected TypeSerializer<Row> createSerializer() {
        return typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
    }

    protected Row[] getSortedTestData() {
        return data;
    }

    @Override
    protected boolean supportsNullKeys() {
        return true;
    }

    private static Row createRow(Object ... values) {
        Preconditions.checkNotNull((Object)values);
        Preconditions.checkArgument((values.length == 10 ? 1 : 0) != 0);
        Row row = new Row(10);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    static {
        data = new Row[]{RowComparatorWithManyFieldsTests.createRow(null, "b0", "c0", "d0", "e0", "f0", "g0", "h0", "i0", "j0"), RowComparatorWithManyFieldsTests.createRow("a1", "b1", "c1", "d1", "e1", "f1", "g1", "h1", "i1", "j1"), RowComparatorWithManyFieldsTests.createRow("a2", "b2", "c2", "d2", "e2", "f2", "g2", "h2", "i2", "j2"), RowComparatorWithManyFieldsTests.createRow("a3", "b3", "c3", "d3", "e3", "f3", "g3", "h3", "i3", "j3")};
    }
}

