/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;
import org.junit.jupiter.api.Test;

class RowSerializerTest {
    RowSerializerTest() {
    }

    @Test
    void testRowSerializer() {
        TypeInformation rowTypeInfo = Types.ROW_NAMED((String[])new String[]{"a", "b", "c", "d"}, (TypeInformation[])new TypeInformation[]{Types.INT, Types.STRING, Types.DOUBLE, Types.BOOLEAN});
        Row positionedRow = Row.withPositions((RowKind)RowKind.UPDATE_BEFORE, (int)4);
        positionedRow.setKind(RowKind.UPDATE_BEFORE);
        positionedRow.setField(0, (Object)1);
        positionedRow.setField(1, (Object)"a");
        positionedRow.setField(2, null);
        positionedRow.setField(3, (Object)false);
        Row namedRow = Row.withNames((RowKind)RowKind.UPDATE_BEFORE);
        namedRow.setField("a", (Object)1);
        namedRow.setField("b", (Object)"a");
        namedRow.setField("c", null);
        namedRow.setField("d", (Object)false);
        Row sparseNamedRow = Row.withNames((RowKind)RowKind.UPDATE_BEFORE);
        namedRow.setField("a", (Object)1);
        namedRow.setField("b", (Object)"a");
        namedRow.setField("d", (Object)false);
        LinkedHashMap<String, Integer> positionByName = new LinkedHashMap<String, Integer>();
        positionByName.put("a", 0);
        positionByName.put("b", 1);
        positionByName.put("c", 2);
        positionByName.put("d", 3);
        Row namedPositionedRow = RowUtils.createRowWithNamedPositions((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[4], positionByName);
        namedPositionedRow.setField("a", (Object)1);
        namedPositionedRow.setField(1, (Object)"a");
        namedPositionedRow.setField(2, null);
        namedPositionedRow.setField("d", (Object)false);
        TypeSerializer serializer = rowTypeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        RowSerializerTestInstance instance = new RowSerializerTestInstance((TypeSerializer<Row>)serializer, positionedRow, namedRow, sparseNamedRow, namedPositionedRow);
        instance.testAll();
    }

    @Test
    void testLargeRowSerializer() {
        RowTypeInfo typeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Row row = new Row(13);
        row.setField(0, (Object)2);
        row.setField(1, null);
        row.setField(3, null);
        row.setField(4, null);
        row.setField(5, null);
        row.setField(6, null);
        row.setField(7, null);
        row.setField(8, null);
        row.setField(9, null);
        row.setField(10, null);
        row.setField(11, null);
        row.setField(12, (Object)"Test");
        TypeSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        RowSerializerTestInstance testInstance = new RowSerializerTestInstance((TypeSerializer<Row>)serializer, row);
        testInstance.testAll();
    }

    @Test
    void testRowSerializerWithComplexTypes() {
        RowTypeInfo typeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.SHORT_TYPE_INFO}), TypeExtractor.createTypeInfo(MyPojo.class)});
        MyPojo testPojo1 = new MyPojo();
        testPojo1.name = null;
        MyPojo testPojo2 = new MyPojo();
        testPojo2.name = "Test1";
        MyPojo testPojo3 = new MyPojo();
        testPojo3.name = "Test2";
        Row[] data = new Row[]{RowSerializerTest.createRow(RowKind.INSERT, null, null, null, null, null), RowSerializerTest.createRow(RowKind.INSERT, 0, null, null, null, null), RowSerializerTest.createRow(RowKind.INSERT, 0, 0.0, null, null, null), RowSerializerTest.createRow(RowKind.INSERT, 0, 0.0, "a", null, null), RowSerializerTest.createRow(RowKind.INSERT, 1, 0.0, "a", null, null), RowSerializerTest.createRow(RowKind.INSERT, 1, 1.0, "a", null, null), RowSerializerTest.createRow(RowKind.INSERT, 1, 1.0, "b", null, null), RowSerializerTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)1, (Object)false, (Object)2), null), RowSerializerTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)2, (Object)false, (Object)2), null), RowSerializerTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)2), null), RowSerializerTest.createRow(RowKind.UPDATE_AFTER, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), null), RowSerializerTest.createRow(RowKind.DELETE, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), testPojo1), RowSerializerTest.createRow(RowKind.DELETE, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), testPojo2), RowSerializerTest.createRow(RowKind.DELETE, 1, 1.0, "b", new Tuple3((Object)2, (Object)true, (Object)3), testPojo3)};
        TypeSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
        RowSerializerTestInstance testInstance = new RowSerializerTestInstance((TypeSerializer<Row>)serializer, data);
        testInstance.testAll();
    }

    private static Row createRow(RowKind kind, Object f0, Object f1, Object f2, Object f3, Object f4) {
        Row row = new Row(kind, 5);
        row.setField(0, f0);
        row.setField(1, f1);
        row.setField(2, f2);
        row.setField(3, f3);
        row.setField(4, f4);
        return row;
    }

    public static class MyPojo
    implements Serializable,
    Comparable<MyPojo> {
        public String name = null;

        @Override
        public int compareTo(MyPojo o) {
            if (this.name == null && o.name == null) {
                return 0;
            }
            if (this.name == null) {
                return -1;
            }
            if (o.name == null) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return Objects.equals(this.name, myPojo.name);
        }
    }

    private class RowSerializerTestInstance
    extends SerializerTestInstance<Row> {
        RowSerializerTestInstance(TypeSerializer<Row> serializer, Row ... testData) {
            super(serializer, Row.class, -1, testData);
        }
    }
}

