/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KryoClearedBufferTest {
    KryoClearedBufferTest() {
    }

    @Test
    void testOutputBufferedBeingClearedInCaseOfException() throws Exception {
        SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
        serializerConfigImpl.registerTypeWithKryoSerializer(TestRecord.class, (Serializer)new TestRecordSerializer());
        serializerConfigImpl.registerKryoType(TestRecord.class);
        KryoSerializer kryoSerializer = new KryoSerializer(TestRecord.class, (SerializerConfig)serializerConfigImpl);
        int size = 94;
        int bufferSize = 150;
        TestRecord testRecord = new TestRecord(size);
        TestDataOutputView target = new TestDataOutputView(bufferSize);
        kryoSerializer.serialize((Object)testRecord, (DataOutputView)target);
        Assertions.assertThatThrownBy(() -> kryoSerializer.serialize((Object)testRecord, (DataOutputView)target)).isInstanceOf(EOFException.class);
        TestRecord actualRecord = (TestRecord)kryoSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(target.getBuffer())));
        Assertions.assertThat((Object)actualRecord).isEqualTo((Object)testRecord);
        target.clear();
        kryoSerializer.serialize((Object)testRecord, (DataOutputView)target);
        byte[] buffer = target.getBuffer();
        int counter = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != 42) continue;
            ++counter;
        }
        Assertions.assertThat((int)counter).isEqualTo(size);
    }

    public static class TestDataOutputView
    implements DataOutputView {
        private final byte[] buffer;
        private int position;

        public TestDataOutputView(int size) {
            this.buffer = new byte[size];
            this.position = 0;
        }

        public void clear() {
            this.position = 0;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public void checkSize(int numBytes) throws EOFException {
            if (this.position + numBytes > this.buffer.length) {
                throw new EOFException();
            }
        }

        public void skipBytesToWrite(int numBytes) throws IOException {
            this.checkSize(numBytes);
            this.position += numBytes;
        }

        public void write(DataInputView source, int numBytes) throws IOException {
            this.checkSize(numBytes);
            byte[] tempBuffer = new byte[numBytes];
            source.readFully(tempBuffer);
            System.arraycopy(tempBuffer, 0, this.buffer, this.position, numBytes);
            this.position += numBytes;
        }

        public void write(int b) throws IOException {
            this.checkSize(4);
            this.position += 4;
        }

        public void write(byte[] b) throws IOException {
            this.checkSize(b.length);
            System.arraycopy(b, 0, this.buffer, this.position, b.length);
            this.position += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.checkSize(len);
            System.arraycopy(b, off, this.buffer, this.position, len);
            this.position += len;
        }

        public void writeBoolean(boolean v) throws IOException {
            this.checkSize(1);
            ++this.position;
        }

        public void writeByte(int v) throws IOException {
            this.checkSize(1);
            this.buffer[this.position] = (byte)v;
            ++this.position;
        }

        public void writeShort(int v) throws IOException {
            this.checkSize(2);
            this.position += 2;
        }

        public void writeChar(int v) throws IOException {
            this.checkSize(1);
            ++this.position;
        }

        public void writeInt(int v) throws IOException {
            this.checkSize(4);
            this.position += 4;
        }

        public void writeLong(long v) throws IOException {
            this.checkSize(8);
            this.position += 8;
        }

        public void writeFloat(float v) throws IOException {
            this.checkSize(4);
            this.position += 4;
        }

        public void writeDouble(double v) throws IOException {
            this.checkSize(8);
            this.position += 8;
        }

        public void writeBytes(String s) throws IOException {
            byte[] sBuffer = s.getBytes(ConfigConstants.DEFAULT_CHARSET);
            this.checkSize(sBuffer.length);
            System.arraycopy(sBuffer, 0, this.buffer, this.position, sBuffer.length);
            this.position += sBuffer.length;
        }

        public void writeChars(String s) throws IOException {
            byte[] sBuffer = s.getBytes(ConfigConstants.DEFAULT_CHARSET);
            this.checkSize(sBuffer.length);
            System.arraycopy(sBuffer, 0, this.buffer, this.position, sBuffer.length);
            this.position += sBuffer.length;
        }

        public void writeUTF(String s) throws IOException {
            byte[] sBuffer = s.getBytes(ConfigConstants.DEFAULT_CHARSET);
            this.checkSize(sBuffer.length);
            System.arraycopy(sBuffer, 0, this.buffer, this.position, sBuffer.length);
            this.position += sBuffer.length;
        }
    }

    public static class TestRecordSerializer
    extends Serializer<TestRecord>
    implements Serializable {
        private static final long serialVersionUID = 6971996565421454985L;

        public void write(Kryo kryo, Output output, TestRecord object) {
            output.writeInt(object.buffer.length);
            output.write(object.buffer);
        }

        public TestRecord read(Kryo kryo, Input input, Class<TestRecord> type) {
            int length = input.readInt();
            byte[] buffer = input.readBytes(length);
            return new TestRecord(buffer);
        }
    }

    public static class TestRecord {
        private final byte[] buffer;

        public TestRecord(int size) {
            this.buffer = new byte[size];
            Arrays.fill(this.buffer, (byte)42);
        }

        public TestRecord(byte[] buffer) {
            this.buffer = buffer;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestRecord) {
                TestRecord record = (TestRecord)obj;
                return Arrays.equals(this.buffer, record.buffer);
            }
            return false;
        }
    }
}

