/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfigUtilsTest {
    private static final ConfigOption<List<String>> TEST_OPTION = ConfigOptions.key((String)"test.option.key").stringType().asList().noDefaultValue();
    private static final Integer[] intArray = new Integer[]{1, 3, 2, 4};
    private static final List<Integer> intList = Arrays.asList(intArray);

    ConfigUtilsTest() {
    }

    @Test
    void collectionIsCorrectlyPutAndFetched() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, intList, Object::toString);
        List recovered = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assertions.assertThat((List)recovered).isEqualTo(intList);
    }

    @Test
    void arrayIsCorrectlyPutAndFetched() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeArrayToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, (Object[])intArray, Object::toString);
        List recovered = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assertions.assertThat((List)recovered).isEqualTo(intList);
    }

    @Test
    void nullCollectionPutsNothingInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, null, Object::toString);
        Assertions.assertThat((Collection)configurationUnderTest.keySet()).isEmpty();
        Object recovered = configurationUnderTest.get(TEST_OPTION);
        Assertions.assertThat((Object)recovered).isNull();
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assertions.assertThat((List)recoveredList).isEmpty();
    }

    @Test
    void nullArrayPutsNothingInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeArrayToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, null, Object::toString);
        Assertions.assertThat((Collection)configurationUnderTest.keySet()).isEmpty();
        Object recovered = configurationUnderTest.get(TEST_OPTION);
        Assertions.assertThat((Object)recovered).isNull();
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assertions.assertThat((List)recoveredList).isEmpty();
    }

    @Test
    void emptyCollectionPutsNothingInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, Collections.emptyList(), Object::toString);
        List recovered = (List)configurationUnderTest.get(TEST_OPTION);
        Assertions.assertThat((List)recovered).isNull();
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assertions.assertThat((List)recoveredList).isEmpty();
    }

    @Test
    void emptyArrayPutsNothingInConfig() {
        Configuration configurationUnderTest = new Configuration();
        ConfigUtils.encodeArrayToConfig((WritableConfig)configurationUnderTest, TEST_OPTION, (Object[])new Integer[5], Object::toString);
        List recovered = (List)configurationUnderTest.get(TEST_OPTION);
        Assertions.assertThat((List)recovered).isNull();
        List recoveredList = ConfigUtils.decodeListFromConfig((ReadableConfig)configurationUnderTest, TEST_OPTION, Integer::valueOf);
        Assertions.assertThat((List)recoveredList).isEmpty();
    }
}

