/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration.description;

import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.HtmlFormatter;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DescriptionHtmlTest {
    DescriptionHtmlTest() {
    }

    @Test
    void testDescriptionWithLink() {
        Description description = Description.builder().text("This is a text with a link %s", new InlineElement[]{LinkElement.link((String)"https://somepage", (String)"to here")}).build();
        String formattedDescription = new HtmlFormatter().format(description);
        Assertions.assertThat((String)formattedDescription).isEqualTo("This is a text with a link <a href=\"https://somepage\">to here</a>");
    }

    @Test
    void testDescriptionWithPercents() {
        Description description = Description.builder().text("This is a text that has some percentage value of 20%.").build();
        String formattedDescription = new HtmlFormatter().format(description);
        Assertions.assertThat((String)formattedDescription).isEqualTo("This is a text that has some percentage value of 20%.");
    }

    @Test
    void testDescriptionWithMultipleLinks() {
        Description description = Description.builder().text("This is a text with a link %s and another %s", new InlineElement[]{LinkElement.link((String)"https://somepage", (String)"to here"), LinkElement.link((String)"https://link")}).build();
        String formattedDescription = new HtmlFormatter().format(description);
        Assertions.assertThat((String)formattedDescription).isEqualTo("This is a text with a link <a href=\"https://somepage\">to here</a> and another <a href=\"https://link\">https://link</a>");
    }

    @Test
    void testDescriptionWithList() {
        Description description = Description.builder().text("This is some list: ").list(new InlineElement[]{LinkElement.link((String)"http://first_link"), TextElement.text((String)"this is second element of list with a %s", (InlineElement[])new InlineElement[]{LinkElement.link((String)"https://link")})}).build();
        String formattedDescription = new HtmlFormatter().format(description);
        Assertions.assertThat((String)formattedDescription).isEqualTo("This is some list: <ul><li><a href=\"http://first_link\">http://first_link</a></li><li>this is second element of list with a <a href=\"https://link\">https://link</a></li></ul>");
    }

    @Test
    void testDescriptionWithLineBreak() {
        Description description = Description.builder().text("This is first line.").linebreak().text("This is second line.").build();
        String formattedDescription = new HtmlFormatter().format(description);
        Assertions.assertThat((String)formattedDescription).isEqualTo("This is first line.<br />This is second line.");
    }

    @Test
    void testDescriptionWithListAndEscaping() {
        Description description = Description.builder().text("This is some list: ").list(new InlineElement[]{TextElement.text((String)"this is first element with illegal character '>' and '<'")}).build();
        String formattedDescription = new HtmlFormatter().format(description);
        Assertions.assertThat((String)formattedDescription).isEqualTo("This is some list: <ul><li>this is first element with illegal character '&gt;' and '&lt;'</li></ul>");
    }
}

