/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class OffHeapDirectMemorySegmentTest
extends MemorySegmentTestBase {
    OffHeapDirectMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)size);
    }

    @Override
    MemorySegment createSegment(int size, Object owner) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)size, (Object)owner);
    }

    @TestTemplate
    void testHeapSegmentSpecifics() {
        int bufSize = 411;
        MemorySegment seg = this.createSegment(411);
        Assertions.assertThat((boolean)seg.isFreed()).isFalse();
        Assertions.assertThat((boolean)seg.isOffHeap()).isTrue();
        Assertions.assertThat((int)seg.size()).isEqualTo(411);
        Assertions.assertThatThrownBy(() -> ((MemorySegment)seg).getArray()).isInstanceOf(IllegalStateException.class);
        ByteBuffer buf1 = seg.wrap(1, 2);
        ByteBuffer buf2 = seg.wrap(3, 4);
        Assertions.assertThat((Comparable)buf2).isNotSameAs((Object)buf1);
        Assertions.assertThat((int)buf1.position()).isOne();
        Assertions.assertThat((int)buf1.limit()).isEqualTo(3);
        Assertions.assertThat((int)buf2.position()).isEqualTo(3);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(7);
    }
}

