/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class CollectionUtilTest {
    CollectionUtilTest() {
    }

    @Test
    void testPartition() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Collection partitioned = CollectionUtil.partition(list, (int)4);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)partitioned).as("List partitioned into the an incorrect number of partitions", new Object[0])).hasSize(4);
        Assertions.assertThat((Collection)partitioned).allSatisfy(partition -> Assertions.assertThat((List)partition).hasSize(1));
    }

    @Test
    void testOfNullableWithNull() {
        Assertions.assertThat((Collection)CollectionUtil.ofNullable(null)).isEmpty();
    }

    @Test
    void testFromNullableWithObject() {
        Object element = new Object();
        ((ObjectAssert)Assertions.assertThat((Collection)CollectionUtil.ofNullable((Object)element)).singleElement()).isEqualTo(element);
    }

    @Test
    void testComputeCapacity() {
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)0, (float)0.75f)).isOne();
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)1, (float)0.75f)).isEqualTo(2);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)2, (float)0.75f)).isEqualTo(3);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)3, (float)0.75f)).isEqualTo(4);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)4, (float)0.75f)).isEqualTo(6);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)5, (float)0.75f)).isEqualTo(7);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)6, (float)0.75f)).isEqualTo(8);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)7, (float)0.75f)).isEqualTo(10);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)8, (float)0.75f)).isEqualTo(11);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)100, (float)0.75f)).isEqualTo(134);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)1000, (float)0.75f)).isEqualTo(1334);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)10000, (float)0.75f)).isEqualTo(13334);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)0x3FFFFFFF, (float)0.75f)).isEqualTo(0x55555580);
        Assertions.assertThat((int)CollectionUtil.computeRequiredCapacity((int)0x40000000, (float)0.75f)).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThatThrownBy(() -> CollectionUtil.computeRequiredCapacity((int)-1, (float)0.75f)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> CollectionUtil.computeRequiredCapacity((int)Integer.MIN_VALUE, (float)0.75f)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testIsEmptyOrAllElementsNull() {
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Collections.singletonList(null))).isTrue();
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Arrays.asList(null, null))).isTrue();
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Collections.singletonList("test"))).isFalse();
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Arrays.asList(null, "test"))).isFalse();
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Arrays.asList("test", null))).isFalse();
        Assertions.assertThat((boolean)CollectionUtil.isEmptyOrAllElementsNull(Arrays.asList(null, "test", null))).isFalse();
    }

    @Test
    void testCheckedSubTypeCast() {
        ArrayList<B> list = new ArrayList<B>();
        B b = new B();
        C c = new C();
        list.add(b);
        list.add(c);
        list.add(null);
        Collection castSuccess = CollectionUtil.checkedSubTypeCast(list, B.class);
        Iterator iterator = castSuccess.iterator();
        Assertions.assertThat((Object)((B)iterator.next())).isEqualTo((Object)b);
        Assertions.assertThat((Object)((B)iterator.next())).isEqualTo((Object)c);
        Assertions.assertThat((Object)((B)iterator.next())).isNull();
        Assertions.assertThat(iterator).isExhausted();
        Assertions.assertThatThrownBy(() -> CollectionUtil.checkedSubTypeCast((Collection)list, C.class)).isInstanceOf(ClassCastException.class);
    }

    static class C
    extends B {
        C() {
        }
    }

    static class B
    extends A {
        B() {
        }
    }

    static class A {
        A() {
        }
    }
}

