/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collection;
import org.apache.flink.util.AbstractParameterTool;
import org.apache.flink.util.AbstractParameterToolTest;
import org.apache.flink.util.MultipleParameterTool;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class MultipleParameterToolTest
extends AbstractParameterToolTest {
    MultipleParameterToolTest() {
    }

    @Test
    void testFromCliArgsWithMultipleParameters() {
        MultipleParameterTool parameter = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput", "-expectedCount", "15", "--multi", "multiValue1", "--multi", "multiValue2", "--withoutValues", "--negativeFloat", "-0.58", "-isWorking", "true", "--maxByte", "127", "-negativeShort", "-1024"});
        Assertions.assertThat((int)parameter.getNumberOfParameters()).isEqualTo(8);
        this.validate((AbstractParameterTool)parameter);
        Assertions.assertThat((boolean)parameter.has("withoutValues")).isTrue();
        Assertions.assertThat((float)parameter.getFloat("negativeFloat")).isCloseTo(-0.58f, Offset.offset((Number)Float.valueOf(0.1f)));
        Assertions.assertThat((boolean)parameter.getBoolean("isWorking")).isTrue();
        Assertions.assertThat((byte)parameter.getByte("maxByte")).isEqualTo((byte)127);
        Assertions.assertThat((short)parameter.getShort("negativeShort")).isEqualTo((short)-1024);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parameter.get("multi")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Key multi should has only one value");
    }

    @Test
    void testUnrequestedMultiParameter() {
        MultipleParameterTool parameter = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--multi", "v1", "--multi", "v2", "--multi2", "vv1"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"multi", "multi2"});
        Assertions.assertThat((Collection)parameter.getMultiParameter("multi")).containsExactly((Object[])new String[]{"v1", "v2"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).containsExactlyInAnyOrder((Object[])new String[]{"multi2"});
        Assertions.assertThat((Collection)parameter.getMultiParameterRequired("multi2")).containsExactly((Object[])new String[]{"vv1"});
        Assertions.assertThat((Collection)parameter.getUnrequestedParameters()).isEmpty();
    }

    @Test
    void testMerged() {
        MultipleParameterTool parameter1 = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput", "--merge", "v1", "--merge", "v2"});
        MultipleParameterTool parameter2 = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--multi", "multiValue1", "--multi", "multiValue2", "-expectedCount", "15", "--merge", "v3"});
        MultipleParameterTool parameter = parameter1.mergeWith(parameter2);
        this.validate((AbstractParameterTool)parameter);
        Assertions.assertThat((Collection)parameter.getMultiParameter("merge")).containsExactly((Object[])new String[]{"v1", "v2", "v3"});
    }

    @Override
    protected AbstractParameterTool createParameterToolFromArgs(String[] args) {
        return MultipleParameterTool.fromArgs((String[])args);
    }
}

