/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.NumberSequenceIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NumberSequenceIteratorTest {
    NumberSequenceIteratorTest() {
    }

    @Test
    void testSplitRegular() {
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(0L, 10L), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(100L, 100000L), 7);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-100L, 0L), 5);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-100L, 100L), 3);
    }

    @Test
    void testSplittingLargeRangesBy2() {
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(0L, Long.MAX_VALUE), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-1000000000L, Long.MAX_VALUE), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(Long.MIN_VALUE, Long.MAX_VALUE), 2);
    }

    @Test
    void testSplittingTooSmallRanges() {
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(0L, 0L), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-5L, -5L), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-5L, -4L), 3);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(10L, 15L), 10);
    }

    private static void testSplitting(NumberSequenceIterator iter, int numSplits) {
        Object[] splits = iter.split(numSplits);
        Assertions.assertThat((Object[])splits).hasSize(numSplits);
        Assertions.assertThat((long)splits[0].getCurrent()).isEqualTo(iter.getCurrent());
        Assertions.assertThat((long)splits[numSplits - 1].getTo()).isEqualTo(iter.getTo());
        for (int i = 1; i < splits.length; ++i) {
            Assertions.assertThat((long)splits[i].getCurrent()).isEqualTo(splits[i - 1].getTo() + 1L);
        }
        NumberSequenceIteratorTest.testMaxSplitDiff((NumberSequenceIterator[])splits);
    }

    private static void testMaxSplitDiff(NumberSequenceIterator[] iters) {
        long minSplitSize = Long.MAX_VALUE;
        long maxSplitSize = Long.MIN_VALUE;
        for (NumberSequenceIterator iter : iters) {
            long diff = iter.getTo() < iter.getCurrent() ? 0L : iter.getTo() - iter.getCurrent();
            if (diff < 0L) {
                diff = Long.MAX_VALUE;
            }
            minSplitSize = Math.min(minSplitSize, diff);
            maxSplitSize = Math.max(maxSplitSize, diff);
        }
        Assertions.assertThat((maxSplitSize == minSplitSize || maxSplitSize - 1L == minSplitSize ? 1 : 0) != 0).isTrue();
    }
}

