/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.types.StringValue;
import org.apache.flink.util.StringValueUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringValueUtilsTest {
    StringValueUtilsTest() {
    }

    @Test
    void testToLowerCaseConverting() {
        StringValue testString = new StringValue((CharSequence)"TEST");
        StringValueUtils.toLowerCase((StringValue)testString);
        Assertions.assertThat((Object)testString).isEqualTo((Object)new StringValue((CharSequence)"test"));
    }

    @Test
    void testReplaceNonWordChars() {
        StringValue testString = new StringValue((CharSequence)"TEST123_@");
        StringValueUtils.replaceNonWordChars((StringValue)testString, (char)'!');
        Assertions.assertThat((Object)testString).isEqualTo((Object)new StringValue((CharSequence)"TEST123_!"));
    }

    @Test
    void testTokenizerOnStringWithoutNexToken() {
        StringValue testString = new StringValue((CharSequence)"test");
        StringValueUtils.WhitespaceTokenizer tokenizer = new StringValueUtils.WhitespaceTokenizer();
        tokenizer.setStringToTokenize(testString);
        tokenizer.next(testString);
        Assertions.assertThat((boolean)tokenizer.next(testString)).isFalse();
    }

    @Test
    void testTokenizerOnStringWithNexToken() {
        StringValue testString = new StringValue((CharSequence)"test test");
        StringValueUtils.WhitespaceTokenizer tokenizer = new StringValueUtils.WhitespaceTokenizer();
        tokenizer.setStringToTokenize(testString);
        Assertions.assertThat((boolean)tokenizer.next(testString)).isTrue();
    }

    @Test
    void testTokenizerOnStringOnlyWithDelimiter() {
        StringValue testString = new StringValue((CharSequence)"    ");
        StringValueUtils.WhitespaceTokenizer tokenizer = new StringValueUtils.WhitespaceTokenizer();
        tokenizer.setStringToTokenize(testString);
        Assertions.assertThat((boolean)tokenizer.next(testString)).isFalse();
    }
}

