/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.Duration;
import java.util.stream.Stream;
import org.apache.flink.util.TimeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TimeUtilsPrettyPrintingTest {
    TimeUtilsPrettyPrintingTest() {
    }

    private static Stream<Arguments> testDurationAndExpectedString() {
        return Stream.of(Arguments.of((Object[])new Object[]{Duration.ofMinutes(3L).plusSeconds(30L), "210 s"}), Arguments.of((Object[])new Object[]{Duration.ofNanos(100L), "100 ns"}), Arguments.of((Object[])new Object[]{Duration.ofSeconds(120L), "2 min"}), Arguments.of((Object[])new Object[]{Duration.ofMillis(200L), "200 ms"}), Arguments.of((Object[])new Object[]{Duration.ofHours(1L).plusSeconds(3L), "3603 s"}), Arguments.of((Object[])new Object[]{Duration.ofSeconds(0L), "0 ms"}), Arguments.of((Object[])new Object[]{Duration.ofMillis(60000L), "1 min"}), Arguments.of((Object[])new Object[]{Duration.ofHours(23L), "23 h"}), Arguments.of((Object[])new Object[]{Duration.ofMillis(-1L), "-1 ms"}), Arguments.of((Object[])new Object[]{Duration.ofDays(1L), "1 d"}), Arguments.of((Object[])new Object[]{Duration.ofHours(24L), "1 d"}), Arguments.of((Object[])new Object[]{Duration.ofMillis(Long.MAX_VALUE), "9223372036854775807 ms"}), Arguments.of((Object[])new Object[]{Duration.ofMillis(Long.MAX_VALUE).plusNanos(1L), "9223372036854775807000001 ns"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testDurationAndExpectedString"})
    void testFormatting(Duration duration, String expectedString) {
        Assertions.assertThat((String)TimeUtils.formatWithHighestUnit((Duration)duration)).isEqualTo(expectedString);
    }
}

