/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.api.extension.window.strategy;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.datastream.api.extension.window.strategy.WindowStrategy;

@Experimental
public class SlidingTimeWindowStrategy
extends WindowStrategy {
    private final Duration windowSize;
    private final Duration windowSlideInterval;
    private final WindowStrategy.TimeType timeType;
    private final Duration allowedLateness;

    public SlidingTimeWindowStrategy(Duration windowSize, Duration windowSlideInterval) {
        this(windowSize, windowSlideInterval, WindowStrategy.TimeType.EVENT);
    }

    public SlidingTimeWindowStrategy(Duration windowSize, Duration windowSlideInterval, WindowStrategy.TimeType timeType) {
        this(windowSize, windowSlideInterval, timeType, Duration.ZERO);
    }

    public SlidingTimeWindowStrategy(Duration windowSize, Duration windowSlideInterval, WindowStrategy.TimeType timeType, Duration allowedLateness) {
        this.windowSize = windowSize;
        this.windowSlideInterval = windowSlideInterval;
        this.timeType = timeType;
        this.allowedLateness = allowedLateness;
    }

    public Duration getWindowSize() {
        return this.windowSize;
    }

    public Duration getWindowSlideInterval() {
        return this.windowSlideInterval;
    }

    public WindowStrategy.TimeType getTimeType() {
        return this.timeType;
    }

    public Duration getAllowedLateness() {
        return this.allowedLateness;
    }
}

