/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.eventtime.functions;

import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.api.common.watermark.WatermarkDeclaration;
import org.apache.flink.api.common.watermark.WatermarkHandlingResult;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoInputBroadcastEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.timer.EventTimeManager;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.EventTimeExtensionImpl;
import org.apache.flink.datastream.impl.extension.eventtime.timer.DefaultEventTimeManager;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.runtime.watermark.extension.eventtime.EventTimeWatermarkHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class EventTimeWrappedTwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT>
implements TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> {
    private final TwoInputBroadcastEventTimeStreamProcessFunction<IN1, IN2, OUT> wrappedUserFunction;
    private transient EventTimeManager eventTimeManager;
    private transient EventTimeWatermarkHandler eventTimeWatermarkHandler;

    public EventTimeWrappedTwoInputBroadcastStreamProcessFunction(TwoInputBroadcastEventTimeStreamProcessFunction<IN1, IN2, OUT> wrappedUserFunction) {
        this.wrappedUserFunction = (TwoInputBroadcastEventTimeStreamProcessFunction)Preconditions.checkNotNull(wrappedUserFunction);
    }

    public void open(NonPartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.initEventTimeProcessFunction(this.eventTimeManager);
        this.wrappedUserFunction.open(ctx);
    }

    public void initEventTimeExtension(@Nullable InternalTimerService<VoidNamespace> timerService, Supplier<Long> eventTimeSupplier, EventTimeWatermarkHandler eventTimeWatermarkHandler) {
        this.eventTimeManager = new DefaultEventTimeManager(timerService, eventTimeSupplier);
        this.eventTimeWatermarkHandler = eventTimeWatermarkHandler;
    }

    public void processRecordFromNonBroadcastInput(IN1 record, Collector<OUT> output, PartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.processRecordFromNonBroadcastInput(record, output, ctx);
    }

    public void processRecordFromBroadcastInput(IN2 record, NonPartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.processRecordFromBroadcastInput(record, ctx);
    }

    public void endBroadcastInput(NonPartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.endBroadcastInput(ctx);
    }

    public void endNonBroadcastInput(NonPartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.endNonBroadcastInput(ctx);
    }

    public void onProcessingTimer(long timestamp, Collector<OUT> output, PartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.onProcessingTimer(timestamp, output, ctx);
    }

    public WatermarkHandlingResult onWatermarkFromBroadcastInput(Watermark watermark, Collector<OUT> output, NonPartitionedContext<OUT> ctx) throws Exception {
        if (EventTimeExtensionImpl.isEventTimeExtensionWatermark(watermark)) {
            try {
                EventTimeWatermarkHandler.EventTimeUpdateStatus eventTimeUpdateStatus = this.eventTimeWatermarkHandler.processWatermark(watermark, 0);
                if (eventTimeUpdateStatus.isEventTimeUpdated()) {
                    this.wrappedUserFunction.onEventTimeWatermark(eventTimeUpdateStatus.getNewEventTime(), output, ctx);
                }
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            return WatermarkHandlingResult.POLL;
        }
        return this.wrappedUserFunction.onWatermarkFromBroadcastInput(watermark, output, ctx);
    }

    public WatermarkHandlingResult onWatermarkFromNonBroadcastInput(Watermark watermark, Collector<OUT> output, NonPartitionedContext<OUT> ctx) throws Exception {
        if (EventTimeExtensionImpl.isEventTimeExtensionWatermark(watermark)) {
            try {
                EventTimeWatermarkHandler.EventTimeUpdateStatus eventTimeUpdateStatus = this.eventTimeWatermarkHandler.processWatermark(watermark, 1);
                if (eventTimeUpdateStatus.isEventTimeUpdated()) {
                    this.wrappedUserFunction.onEventTimeWatermark(eventTimeUpdateStatus.getNewEventTime(), output, ctx);
                }
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            return WatermarkHandlingResult.POLL;
        }
        return this.wrappedUserFunction.onWatermarkFromBroadcastInput(watermark, output, ctx);
    }

    public void onEventTime(long timestamp, Collector<OUT> output, PartitionedContext<OUT> ctx) throws Exception {
        this.wrappedUserFunction.onEventTimer(timestamp, output, ctx);
    }

    public void close() throws Exception {
        this.wrappedUserFunction.close();
    }

    public Set<StateDeclaration> usesStates() {
        return this.wrappedUserFunction.usesStates();
    }

    public Set<? extends WatermarkDeclaration> declareWatermarks() {
        return this.wrappedUserFunction.declareWatermarks();
    }

    public TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> getWrappedUserFunction() {
        return this.wrappedUserFunction;
    }
}

