/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs;

import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

public class GSFileSystemOptions {
    public static final ConfigOption<String> WRITER_TEMPORARY_BUCKET_NAME = ConfigOptions.key((String)"gs.writer.temporary.bucket.name").stringType().noDefaultValue().withDescription("This option sets the bucket name used by the recoverable writer to store temporary files. If not specified, temporary files are stored in the same bucket as the final file being written.");
    public static final ConfigOption<MemorySize> WRITER_CHUNK_SIZE = ConfigOptions.key((String)"gs.writer.chunk.size").memoryType().noDefaultValue().withDescription("This option sets the chunk size for writes to the underlying Google storage. If set, this must be a multiple of 256KB. If not set, writes will use Google's default chunk size.");
    private final Configuration flinkConfig;

    public GSFileSystemOptions(Configuration flinkConfig) {
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)flinkConfig);
        this.flinkConfig.getOptional(WRITER_CHUNK_SIZE).ifPresent(chunkSize -> Preconditions.checkArgument((chunkSize.getBytes() > 0L && chunkSize.getBytes() % 262144L == 0L ? 1 : 0) != 0, (Object)"Writer chunk size must be greater than zero and a multiple of 256KB"));
    }

    public Optional<String> getWriterTemporaryBucketName() {
        return this.flinkConfig.getOptional(WRITER_TEMPORARY_BUCKET_NAME);
    }

    public Optional<MemorySize> getWriterChunkSize() {
        return this.flinkConfig.getOptional(WRITER_CHUNK_SIZE);
    }

    public String toString() {
        return "GSFileSystemOptions{writerTemporaryBucketName=" + this.getWriterTemporaryBucketName() + ", writerChunkSize=" + this.getWriterChunkSize() + '}';
    }
}

