/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferHandlePool;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.MetadataField;
import com.google.cloud.storage.ParallelCompositeUploadWritableByteChannel;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;

@BetaApi
@Immutable
public final class ParallelCompositeUploadBlobWriteSessionConfig
extends BlobWriteSessionConfig {
    private static final int MAX_PARTS_PER_COMPOSE = 32;
    private final int maxPartsPerCompose;
    private final ExecutorSupplier executorSupplier;
    private final BufferAllocationStrategy bufferAllocationStrategy;
    private final PartNamingStrategy partNamingStrategy;
    private final PartCleanupStrategy partCleanupStrategy;

    private ParallelCompositeUploadBlobWriteSessionConfig(int maxPartsPerCompose, ExecutorSupplier executorSupplier, BufferAllocationStrategy bufferAllocationStrategy, PartNamingStrategy partNamingStrategy, PartCleanupStrategy partCleanupStrategy) {
        this.maxPartsPerCompose = maxPartsPerCompose;
        this.executorSupplier = executorSupplier;
        this.bufferAllocationStrategy = bufferAllocationStrategy;
        this.partNamingStrategy = partNamingStrategy;
        this.partCleanupStrategy = partCleanupStrategy;
    }

    @InternalApi
    ParallelCompositeUploadBlobWriteSessionConfig withMaxPartsPerCompose(int maxPartsPerCompose) {
        Preconditions.checkArgument(2 <= maxPartsPerCompose && maxPartsPerCompose <= 32, "2 <= maxPartsPerCompose <= 32 (2 <= %s <= 32)", maxPartsPerCompose);
        return new ParallelCompositeUploadBlobWriteSessionConfig(maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withExecutorSupplier(ExecutorSupplier executorSupplier) {
        Preconditions.checkNotNull(executorSupplier, "executorSupplier must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withBufferAllocationStrategy(BufferAllocationStrategy bufferAllocationStrategy) {
        Preconditions.checkNotNull(bufferAllocationStrategy, "bufferAllocationStrategy must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, bufferAllocationStrategy, this.partNamingStrategy, this.partCleanupStrategy);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withPartNamingStrategy(PartNamingStrategy partNamingStrategy) {
        Preconditions.checkNotNull(partNamingStrategy, "partNamingStrategy must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, partNamingStrategy, this.partCleanupStrategy);
    }

    @BetaApi
    public ParallelCompositeUploadBlobWriteSessionConfig withPartCleanupStrategy(PartCleanupStrategy partCleanupStrategy) {
        Preconditions.checkNotNull(partCleanupStrategy, "partCleanupStrategy must be non null");
        return new ParallelCompositeUploadBlobWriteSessionConfig(this.maxPartsPerCompose, this.executorSupplier, this.bufferAllocationStrategy, this.partNamingStrategy, partCleanupStrategy);
    }

    @BetaApi
    static ParallelCompositeUploadBlobWriteSessionConfig withDefaults() {
        return new ParallelCompositeUploadBlobWriteSessionConfig(32, ExecutorSupplier.cachedPool(), BufferAllocationStrategy.simple(0x1000000), PartNamingStrategy.noPrefix(), PartCleanupStrategy.always());
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        Executor executor = (Executor)this.executorSupplier.get();
        BufferHandlePool bufferHandlePool = (BufferHandlePool)this.bufferAllocationStrategy.get();
        return new ParallelCompositeUploadWriterFactory(clock, executor, bufferHandlePool);
    }

    @BetaApi
    @Immutable
    public static class PartCleanupStrategy
    implements Serializable {
        private static final long serialVersionUID = -1434253614347199051L;
        private final boolean deletePartsOnSuccess;
        private final boolean deleteAllOnError;

        private PartCleanupStrategy(boolean deletePartsOnSuccess, boolean deleteAllOnError) {
            this.deletePartsOnSuccess = deletePartsOnSuccess;
            this.deleteAllOnError = deleteAllOnError;
        }

        boolean isDeletePartsOnSuccess() {
            return this.deletePartsOnSuccess;
        }

        boolean isDeleteAllOnError() {
            return this.deleteAllOnError;
        }

        @BetaApi
        PartCleanupStrategy withDeleteAllOnError(boolean deleteAllOnError) {
            return new PartCleanupStrategy(this.deletePartsOnSuccess, deleteAllOnError);
        }

        @BetaApi
        public static PartCleanupStrategy always() {
            return new PartCleanupStrategy(true, true);
        }

        @BetaApi
        public static PartCleanupStrategy onlyOnSuccess() {
            return new PartCleanupStrategy(true, false);
        }

        @BetaApi
        public static PartCleanupStrategy never() {
            return new PartCleanupStrategy(false, false);
        }
    }

    @BetaApi
    @Immutable
    public static abstract class PartNamingStrategy
    implements Serializable {
        private static final long serialVersionUID = 8343436026774231869L;
        private static final String FIELD_SEPARATOR = ";";
        private static final Base64.Encoder B64 = Base64.getUrlEncoder().withoutPadding();
        private static final HashFunction OBJECT_NAME_HASH_FUNCTION = Hashing.goodFastHash(128);
        private final SecureRandom rand;

        @InternalApi
        @VisibleForTesting
        PartNamingStrategy(SecureRandom rand) {
            this.rand = rand;
        }

        String fmtName(String ultimateObjectName, MetadataField.PartRange partRange) {
            byte[] bytes = new byte[16];
            this.rand.nextBytes(bytes);
            String randomKey = B64.encodeToString(bytes);
            HashCode hashCode = OBJECT_NAME_HASH_FUNCTION.hashString(ultimateObjectName, StandardCharsets.UTF_8);
            String nameDigest = B64.encodeToString(hashCode.asBytes());
            return this.fmtFields(randomKey, nameDigest, partRange.encode());
        }

        abstract String fmtFields(String var1, String var2, String var3);

        @BetaApi
        public static PartNamingStrategy noPrefix() {
            SecureRandom rand = new SecureRandom();
            return new NoPrefix(rand);
        }

        @BetaApi
        public static PartNamingStrategy prefix(String prefixPattern) {
            Preconditions.checkNotNull(prefixPattern, "prefixPattern must be non null");
            SecureRandom rand = new SecureRandom();
            return new WithPrefix(rand, prefixPattern);
        }

        static final class NoPrefix
        extends PartNamingStrategy {
            private static final long serialVersionUID = 5202415556658566017L;

            public NoPrefix(SecureRandom rand) {
                super(rand);
            }

            @Override
            protected String fmtFields(String randomKey, String nameDigest, String partRange) {
                return randomKey + PartNamingStrategy.FIELD_SEPARATOR + nameDigest + PartNamingStrategy.FIELD_SEPARATOR + partRange + ".part";
            }
        }

        static final class WithPrefix
        extends PartNamingStrategy {
            private static final long serialVersionUID = 5709330763161570411L;
            private final String prefix;

            private WithPrefix(SecureRandom rand, String prefix) {
                super(rand);
                this.prefix = prefix;
            }

            @Override
            protected String fmtFields(String randomKey, String nameDigest, String partRange) {
                return this.prefix + "/" + randomKey + PartNamingStrategy.FIELD_SEPARATOR + nameDigest + PartNamingStrategy.FIELD_SEPARATOR + partRange + ".part";
            }
        }
    }

    @BetaApi
    @Immutable
    public static abstract class ExecutorSupplier
    extends Factory<Executor>
    implements Serializable {
        private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(1);

        private ExecutorSupplier() {
        }

        @BetaApi
        public static ExecutorSupplier cachedPool() {
            return new CachedSupplier();
        }

        @BetaApi
        public static ExecutorSupplier fixedPool(int poolSize) {
            return new FixedSupplier(poolSize);
        }

        @BetaApi
        public static ExecutorSupplier useExecutor(Executor executor) {
            Objects.requireNonNull(executor, "executor must be non null");
            return new SuppliedExecutorSupplier(executor);
        }

        private static @NonNull ThreadFactory newThreadFactory() {
            return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("c.g.c:g-c-s:pcu-" + INSTANCE_COUNTER.getAndIncrement() + "-%d").build();
        }

        private static class CachedSupplier
        extends ExecutorSupplier
        implements Serializable {
            private static final long serialVersionUID = 7768210719775319260L;

            private CachedSupplier() {
            }

            @Override
            Executor get() {
                ThreadFactory threadFactory = ExecutorSupplier.newThreadFactory();
                return Executors.newCachedThreadPool(threadFactory);
            }
        }

        private static class FixedSupplier
        extends ExecutorSupplier
        implements Serializable {
            private static final long serialVersionUID = 7771825977551614347L;
            private final int poolSize;

            public FixedSupplier(int poolSize) {
                this.poolSize = poolSize;
            }

            @Override
            Executor get() {
                ThreadFactory threadFactory = ExecutorSupplier.newThreadFactory();
                return Executors.newFixedThreadPool(this.poolSize, threadFactory);
            }
        }

        private static class SuppliedExecutorSupplier
        extends ExecutorSupplier {
            private final Executor executor;

            public SuppliedExecutorSupplier(Executor executor) {
                this.executor = executor;
            }

            @Override
            Executor get() {
                return this.executor;
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                throw new InvalidClassException(this.getClass().getName() + "; Not serializable");
            }
        }
    }

    @BetaApi
    @Immutable
    public static abstract class BufferAllocationStrategy
    extends Factory<BufferHandlePool>
    implements Serializable {
        private BufferAllocationStrategy() {
        }

        @BetaApi
        public static BufferAllocationStrategy simple(int capacity) {
            return new SimpleBufferAllocationStrategy(capacity);
        }

        @BetaApi
        public static BufferAllocationStrategy fixedPool(int bufferCount, int bufferCapacity) {
            return new FixedPoolBufferAllocationStrategy(bufferCount, bufferCapacity);
        }

        private static class SimpleBufferAllocationStrategy
        extends BufferAllocationStrategy {
            private static final long serialVersionUID = 8884826090481043434L;
            private final int capacity;

            private SimpleBufferAllocationStrategy(int capacity) {
                this.capacity = capacity;
            }

            @Override
            BufferHandlePool get() {
                return BufferHandlePool.simple(this.capacity);
            }
        }

        private static class FixedPoolBufferAllocationStrategy
        extends BufferAllocationStrategy {
            private static final long serialVersionUID = 3288902741819257066L;
            private final int bufferCount;
            private final int bufferCapacity;

            private FixedPoolBufferAllocationStrategy(int bufferCount, int bufferCapacity) {
                this.bufferCount = bufferCount;
                this.bufferCapacity = bufferCapacity;
            }

            @Override
            BufferHandlePool get() {
                return BufferHandlePool.fixedPool(this.bufferCount, this.bufferCapacity);
            }
        }
    }

    private class ParallelCompositeUploadWriterFactory
    implements BlobWriteSessionConfig.WriterFactory {
        private final Clock clock;
        private final Executor executor;
        private final BufferHandlePool bufferHandlePool;

        private ParallelCompositeUploadWriterFactory(Clock clock, Executor executor, BufferHandlePool bufferHandlePool) {
            this.clock = clock;
            this.executor = executor;
            this.bufferHandlePool = bufferHandlePool;
        }

        @Override
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s2, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, Conversions.Decoder<WriteObjectResponse, BlobInfo> d) {
            return new PCUSession(s2, info, opts);
        }

        private final class PCUSession
        implements WritableByteChannelSession<BufferedWritableByteChannelSession.BufferedWritableByteChannel, BlobInfo> {
            private final SettableApiFuture<BlobInfo> result;
            private final StorageInternal storageInternal;
            private final BlobInfo info;
            private final UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts;

            private PCUSession(StorageInternal storageInternal, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
                this.storageInternal = storageInternal;
                this.info = info;
                this.opts = opts;
                this.result = SettableApiFuture.create();
            }

            @Override
            public ApiFuture<BufferedWritableByteChannelSession.BufferedWritableByteChannel> openAsync() {
                ParallelCompositeUploadWritableByteChannel channel = new ParallelCompositeUploadWritableByteChannel(ParallelCompositeUploadWriterFactory.this.bufferHandlePool, ParallelCompositeUploadWriterFactory.this.executor, ParallelCompositeUploadBlobWriteSessionConfig.this.partNamingStrategy, ParallelCompositeUploadBlobWriteSessionConfig.this.partCleanupStrategy, ParallelCompositeUploadBlobWriteSessionConfig.this.maxPartsPerCompose, this.result, this.storageInternal, this.info, this.opts);
                return ApiFutures.immediateFuture(channel);
            }

            @Override
            public ApiFuture<BlobInfo> getResult() {
                return this.result;
            }
        }
    }

    private static abstract class Factory<T>
    implements Serializable {
        private static final long serialVersionUID = 271806144227661056L;

        private Factory() {
        }

        abstract T get();
    }
}

