/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.cooplock;

import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationType;
import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class CoopLockRecord {
    private String clientId;
    private String operationId;
    private Instant operationTime;
    private CoopLockOperationType operationType;
    private Instant lockExpiration;
    private Set<String> resources = new TreeSet<String>();

    public String getClientId() {
        return this.clientId;
    }

    public CoopLockRecord setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public CoopLockRecord setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public Instant getOperationTime() {
        return this.operationTime;
    }

    public CoopLockRecord setOperationTime(Instant operationTime) {
        this.operationTime = operationTime;
        return this;
    }

    public CoopLockOperationType getOperationType() {
        return this.operationType;
    }

    public CoopLockRecord setOperationType(CoopLockOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public Instant getLockExpiration() {
        return this.lockExpiration;
    }

    public CoopLockRecord setLockExpiration(Instant lockExpiration) {
        this.lockExpiration = lockExpiration;
        return this;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public CoopLockRecord setResources(Set<String> resources) {
        this.resources = new TreeSet<String>(resources);
        return this;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CoopLockRecord && this.equalsInternal((CoopLockRecord)obj);
    }

    private boolean equalsInternal(CoopLockRecord other) {
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.operationId, other.operationId) && Objects.equals(this.operationTime, other.operationTime) && this.operationType == other.operationType && Objects.equals(this.lockExpiration, other.lockExpiration) && Objects.equals(this.resources, other.resources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.operationId, this.operationTime, this.operationType, this.lockExpiration, this.resources});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("clientId", this.clientId).add("operationId", this.operationId).add("operationTime", this.operationTime).add("operationType", (Object)this.operationType).add("lockExpiration", this.lockExpiration).add("resources", this.resources).toString();
    }
}

