/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopDummyReporter;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopInputSplit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class HadoopInputFormatBase<K, V, T>
extends HadoopInputFormatCommonBase<T, HadoopInputSplit> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HadoopInputFormatBase.class);
    private static final Object OPEN_MUTEX = new Object();
    private static final Object CONFIGURE_MUTEX = new Object();
    private static final Object CLOSE_MUTEX = new Object();
    private InputFormat<K, V> mapredInputFormat;
    protected Class<K> keyClass;
    protected Class<V> valueClass;
    private JobConf jobConf;
    protected transient K key;
    protected transient V value;
    private transient RecordReader<K, V> recordReader;
    protected transient boolean fetched = false;
    protected transient boolean hasNext;

    public HadoopInputFormatBase(InputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, JobConf job) {
        super(job.getCredentials());
        this.mapredInputFormat = mapredInputFormat;
        this.keyClass = key;
        this.valueClass = value;
        HadoopUtils.mergeHadoopConf(job);
        this.jobConf = job;
        ReflectionUtils.setConf(mapredInputFormat, (org.apache.hadoop.conf.Configuration)this.jobConf);
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration parameters) {
        Object object = CONFIGURE_MUTEX;
        synchronized (object) {
            if (this.mapredInputFormat instanceof Configurable) {
                ((Configurable)this.mapredInputFormat).setConf((org.apache.hadoop.conf.Configuration)this.jobConf);
            } else if (this.mapredInputFormat instanceof JobConfigurable) {
                ((JobConfigurable)this.mapredInputFormat).configure(this.jobConf);
            }
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        block5: {
            if (!(this.mapredInputFormat instanceof FileInputFormat)) {
                return null;
            }
            FileInputFormat.FileBaseStatistics cachedFileStats = cachedStats != null && cachedStats instanceof FileInputFormat.FileBaseStatistics ? (FileInputFormat.FileBaseStatistics)cachedStats : null;
            try {
                org.apache.hadoop.fs.Path[] paths = FileInputFormat.getInputPaths((JobConf)this.jobConf);
                return this.getFileStats(cachedFileStats, paths, new ArrayList<FileStatus>(1));
            }
            catch (IOException ioex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not determine statistics due to an io error: " + ioex.getMessage());
                }
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error("Unexpected problem while getting the file statistics: " + t.getMessage(), t);
            }
        }
        return null;
    }

    public HadoopInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        InputSplit[] splitArray = this.mapredInputFormat.getSplits(this.jobConf, minNumSplits);
        HadoopInputSplit[] hiSplit = new HadoopInputSplit[splitArray.length];
        for (int i = 0; i < splitArray.length; ++i) {
            hiSplit[i] = new HadoopInputSplit(i, splitArray[i], this.jobConf);
        }
        return hiSplit;
    }

    public InputSplitAssigner getInputSplitAssigner(HadoopInputSplit[] inputSplits) {
        return new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(HadoopInputSplit split) throws IOException {
        Object object = OPEN_MUTEX;
        synchronized (object) {
            this.recordReader = this.mapredInputFormat.getRecordReader(split.getHadoopInputSplit(), this.jobConf, (Reporter)new HadoopDummyReporter());
            if (this.recordReader instanceof Configurable) {
                ((Configurable)this.recordReader).setConf((org.apache.hadoop.conf.Configuration)this.jobConf);
            }
            this.key = this.recordReader.createKey();
            this.value = this.recordReader.createValue();
            this.fetched = false;
        }
    }

    public boolean reachedEnd() throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        return !this.hasNext;
    }

    protected void fetchNext() throws IOException {
        this.hasNext = this.recordReader.next(this.key, this.value);
        this.fetched = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = CLOSE_MUTEX;
        synchronized (object) {
            this.recordReader.close();
        }
    }

    private FileInputFormat.FileBaseStatistics getFileStats(FileInputFormat.FileBaseStatistics cachedStats, org.apache.hadoop.fs.Path[] hadoopFilePaths, ArrayList<FileStatus> files) throws IOException {
        long latestModTime = 0L;
        for (org.apache.hadoop.fs.Path hadoopPath : hadoopFilePaths) {
            Path filePath = new Path(hadoopPath.toUri());
            FileSystem fs = FileSystem.get((URI)filePath.toUri());
            FileStatus file = fs.getFileStatus(filePath);
            latestModTime = Math.max(latestModTime, file.getModificationTime());
            if (file.isDir()) {
                FileStatus[] fss = fs.listStatus(filePath);
                files.ensureCapacity(files.size() + fss.length);
                for (FileStatus s : fss) {
                    if (s.isDir()) continue;
                    files.add(s);
                    latestModTime = Math.max(s.getModificationTime(), latestModTime);
                }
                continue;
            }
            files.add(file);
        }
        if (cachedStats != null && latestModTime <= cachedStats.getLastModificationTime()) {
            return cachedStats;
        }
        long len = 0L;
        for (FileStatus s : files) {
            len += s.getLen();
        }
        if (len <= 0L) {
            len = -1L;
        }
        return new FileInputFormat.FileBaseStatistics(latestModTime, len, -1.0f);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeUTF(this.mapredInputFormat.getClass().getName());
        out.writeUTF(this.keyClass.getName());
        out.writeUTF(this.valueClass.getName());
        this.jobConf.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        String hadoopInputFormatClassName = in.readUTF();
        String keyClassName = in.readUTF();
        String valueClassName = in.readUTF();
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
        }
        this.jobConf.readFields((DataInput)in);
        try {
            this.mapredInputFormat = (InputFormat)Class.forName(hadoopInputFormatClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the hadoop input format", e);
        }
        try {
            this.keyClass = Class.forName(keyClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find key class.", e);
        }
        try {
            this.valueClass = Class.forName(valueClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find value class.", e);
        }
        ReflectionUtils.setConf(this.mapredInputFormat, (org.apache.hadoop.conf.Configuration)this.jobConf);
        this.jobConf.getCredentials().addAll(this.credentials);
        Credentials currentUserCreds = HadoopInputFormatBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            this.jobConf.getCredentials().addAll(currentUserCreds);
        }
    }
}

